//
//  calcPerfClass.m
//  H135
//
//  Created by Claus Richter on 10/29/17.
//
//

#import "calcPerfClass.h"

#import "ViewController.h"

#import "importPerfData.h"



@interface calcPerfClass ()

@end

@implementation calcPerfClass

#define colorSet [UIColor colorWithRed: 255.0/255.0 green: 0.0/255.0 blue: 0.0/255.0 alpha: 1.0] // this is red
#define colorSetOrange [UIColor colorWithRed: 255/255.0 green: 124/255.0 blue: 0/255.0 alpha: 1.0] // this is orange


#define GreenColor [UIColor colorWithRed: 33.0/255.0 green: 176.0/255.0 blue: 21.0/255.0 alpha: 1.0] // this is green

//#define colorSet [UIColor colorWithRed: 255.0/255.0 green: 0.0/255.0 blue: 231/255.0 alpha: 1.0] // this is pink

// blue #define colorSet [UIColor colorWithRed: 0/255.0 green: 157/255.0 blue: 255/255.0 alpha: 1.0]


- (void) resetPreviousChartName {
    
    previousChartName = @"9999";
    
    chartImagesDictionary = [[NSMutableDictionary alloc] init];
    
}



- (void) transferMethod:  (float)receivedOAT  sendPA:(float)receivedPA  sendHeadWindKts:(float)receivedHeadWindKts sendACweight:(float)receivedACweight sendSelectedChartButton:(float)receivedSelectedChartButton   sendISADiff:(float)receivedISADiff   sendAltimeterInches:(float)receivedAltimeterInches sendPenaltyWeight:(float)receivedPenaltyWeight sendPenaltyFtMin:(float)receivedPenaltyFtMin sendFuelWeight:(float)receivedFuelWeight sendDA:(float)receivedDA sendISADIFF:(float)receivedISADIFF {
    
    ISADIFFCelsius = receivedISADIFF;
    
    fuelWeight = receivedFuelWeight;
    
    DensityAlt = receivedDA;
    
    penaltyFtMin = receivedPenaltyFtMin;
    penaltyWeight = receivedPenaltyWeight;
    
    headWindKTS = receivedHeadWindKts;
    acWeight = receivedACweight ;
    
    unchangedACWeight = receivedACweight ;
    
    OAT = receivedOAT;
    Hp = receivedPA;
    selectedChartButton = receivedSelectedChartButton;
    ISADiff = receivedISADiff;
    altimeterInches = receivedAltimeterInches;
    
    
    //NSLog(@"acWeight %.1f ", acWeight );
    
    //NSLog(@"unchangedACWeight %.1f ", unchangedACWeight );
    
    [self calcPerformance];
    
    [self makeOverviewPages];
    
    
    [self catAWarnings];
    
}

- (void) catAWarnings {
    
      ViewController *parent = (ViewController *)self.parentViewController;
    
    UIImage *buttonRed = [UIImage imageNamed:@"button_red.png"];
    UIImage *buttonGrey = [UIImage imageNamed:@"button grey top184x52.png"];
    UIImage *buttonBlue = [UIImage imageNamed:@"button blue top184x52.png"];

    
    actualButtonNumber = 2;
    
    if ([_VTOLMaxMassCeiling.text floatValue] < Hp) {
        UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
        [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateNormal];
        [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateSelected];
        
        triangleTrigger = 1;
        
    }else{
        UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
        [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateNormal];
        if ( [buttonToWarn isSelected ]) {
            [buttonToWarn setBackgroundImage:buttonBlue forState:UIControlStateSelected];
        }else{
            [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateSelected];
        }
    }

   
    
    
    
    
    
    actualButtonNumber = 3;
    
    //NSLog(@"catAWarnings _PC2PIS8 %@  flagPC2error %d", _PC2PIS8.text, flagPC2error);
    
    
 
    if (flagPC2error >0) {
        UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
        [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateNormal];
        [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateSelected];
        
        triangleTrigger = 1;
        
    }else{
        UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
        [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateNormal];
        if ( [buttonToWarn isSelected ]) {
            [buttonToWarn setBackgroundImage:buttonBlue forState:UIControlStateSelected];
        }else{
            [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateSelected];
        }
    }
    
    
   
    
    
}


- (void) makeOverviewPages {
    
    
    //NSLog(@"makeOverviewPages ");
    
    
    
    // get results for H145:
    
    float AEO_HIGE_TOP = 0;
    
    float AEO_HIGE_TOP_CX = 0;
    
    

    
    float Seg2Vtoss_3700kg = 0;
    float Seg2Vtoss_3200kg = 0;
    
    float addGain2Vy = 0;
    
    float CATAenRouteOEIMCP = 0;
    //NSLog(@"resultsAllChartNames %@", resultsAllChartNames);
    
    float Seg1Vtoss_3700kg = 0;
    float Seg1Vtoss_3200kg = 0;
    
    float seg1Percent = 0;
    
    //NSLog(@"resultsAllChartNames %@", resultsAllChartNames );
    
    
    for (int i = 1; i < resultsAllChartNames.count; i++) {
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"MaxMass_Sup911_FigB1"].location != NSNotFound & [[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"CX"].location == NSNotFound   ) {
            _CHMaxMass.text = [[NSString alloc] initWithFormat:@"%.0f kg", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ] ;
        }
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"MaxMass_Sup911_FigB1_CX"].location != NSNotFound   ) {
            _CHCeiling.text = [[NSString alloc] initWithFormat:@"%.0f ft", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ];
        }
        
        
        
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"MaxMass_VTOL_Sup911_FigC4"].location != NSNotFound & [[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"CX"].location == NSNotFound   ) {
             _VTOLMaxMass.text = [[NSString alloc] initWithFormat:@"%.0f kg", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ] ;
        }
        
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"MaxMass_VTOL_Sup911_FigC4_CX"].location != NSNotFound   ) {
            _VTOLMaxMassCeiling.text = [[NSString alloc] initWithFormat:@"%.0f ft", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ];
            catAVtolCeiling = [_VTOLMaxMassCeiling.text floatValue];
        }
        
        
        
        
        
        
        
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"Acc_Vtoss_Vy_VTOL_Sup911_FigC18"].location != NSNotFound   ) {
            _VTOLAccelerationDistance.text = [[NSString alloc] initWithFormat:@"%.0f m", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ];
        }
        
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"MaxMass_VTOL_Training_Sup911_FigD1"].location != NSNotFound   ) {
            _VTOLMaxMassTraining.text = [[NSString alloc] initWithFormat:@"%.0f kg", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ];
        }
        
        
        
        
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"AEO_HIGE_TOP_Sec5_Fig5_15_CX"].location != NSNotFound    ) {
            _AEOHIGETOP.text = [[NSString alloc] initWithFormat:@"%.0f ft", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ];
        }
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"AEO_HOGE_TOP_Sec5_Fig5_19_CX"].location != NSNotFound    ) {
            _AEOHOGETOP.text = [[NSString alloc] initWithFormat:@"%.0f ft", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ];
        }
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"OEI_HIGE_2min_Sec5_Fig5_24_CX"].location != NSNotFound   ) {
            _AEOHIGE2min.text = [[NSString alloc] initWithFormat:@"%.0f ft", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ];
        }
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"OEI_HOGE_2min_Sec5_Fig5_26_CX"].location != NSNotFound   ) {
            _AEOHOGE2min.text = [[NSString alloc] initWithFormat:@"%.0f ft", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ];
        }

        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"OEI_HOGE_30sec_Sec5_Fig5_27_CX"].location != NSNotFound  ) {
            _AEOHOGE30sec.text = [[NSString alloc] initWithFormat:@"%.0f ft", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ];
        }
        
        
        
       
        
       
        
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"Rejected_TO_Sup911_FigB10"].location != NSNotFound  ) {
            _chRejectedTOdist.text = [[NSString alloc] initWithFormat:@"%.0f m", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ];
        }
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"Continued_TO_Sup911_FigB12"].location != NSNotFound  ) {
            _chContTOdist.text = [[NSString alloc] initWithFormat:@"%.0f m", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ];
        }
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"Acc_Vtoss_Vy_Sup911_FigB14"].location != NSNotFound  ) {
            _chAccelDist.text = [[NSString alloc] initWithFormat:@"%.0f m", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ];
        }
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"Ldg_50ft_Sup911_FigB15"].location != NSNotFound  ) {
            _chLandingDist.text = [[NSString alloc] initWithFormat:@"%.0f m", [[resultsAllChartValues objectAtIndex: i  ] floatValue] ];
        }

        
        
        
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"EnRoute_OEI_MCP_Sup911_FigA25_CX"].location != NSNotFound  ) {
            CATAenRouteOEIMCP = [[resultsAllChartValues objectAtIndex: i  ] floatValue];
            //NSLog(@"********** AEO_HIGE_TOP %.0f", AEO_HIGE_TOP);
        }
        
        
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"HeightGainVy_Sup911_FigA23"].location != NSNotFound  ) {
            addGain2Vy = [[resultsAllChartValues objectAtIndex: i  ] floatValue];
           
        }
        
       
        
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"AEO_HIGE_TOP"].location != NSNotFound  & [[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"CX"].location == NSNotFound ) {
            AEO_HIGE_TOP = [[resultsAllChartValues objectAtIndex: i  ] floatValue];
            //NSLog(@"********** AEO_HIGE_TOP %.0f", AEO_HIGE_TOP);
        }
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"AEO_HIGE_TOP"].location != NSNotFound  & [[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"CX"].location != NSNotFound ) {
            AEO_HIGE_TOP_CX = [[resultsAllChartValues objectAtIndex: i  ] floatValue];
            //NSLog(@"********** AEO_HIGE_TOP_CX  %.0f", AEO_HIGE_TOP_CX);
        }
        
        
        
   
       /*
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"Seg1Vtoss_3700kg"].location != NSNotFound  ) {
            
            //NSLog(@"******  %d", i);
            Seg1Vtoss_3700kg = [[resultsAllChartValues objectAtIndex: i  ] floatValue];
            
        }
        
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"Seg1Vtoss_3200kg"].location != NSNotFound   ) {
            
            //NSLog(@"******  %d", i);
            Seg1Vtoss_3200kg = [[resultsAllChartValues objectAtIndex: i  ] floatValue];
            
        }
       */
       
        
        
        _seg1Distance.text = [[NSString alloc] initWithFormat:@"%.0f m",  ((165.0 / Seg1Vtoss_Selected ) * 100.0) * 0.3048     ];
        _seg1Percent.text = [[NSString alloc] initWithFormat:@"%.2f %%", Seg1Vtoss_Selected ];
       
        
        /*
        if (acWeight <=3200) {
            
            // = Seg1_Vt<3200kg
            seg1Percent =  Seg1Vtoss_3200kg;
            _seg1Distance.text = [[NSString alloc] initWithFormat:@"%.0f m",  ((165.0 / seg1Percent ) * 100.0) * 0.3048     ];
            _seg1Percent.text = [[NSString alloc] initWithFormat:@"%.2f %%", Seg1Vtoss_3700kg ];
            
        }else{
            
            // = Seg1_Vt
            seg1Percent =  Seg1Vtoss_3700kg;
            _seg1Distance.text = [[NSString alloc] initWithFormat:@"%.0f m",  ((165.0 / seg1Percent ) * 100.0) * 0.3048     ];
            _seg1Percent.text = [[NSString alloc] initWithFormat:@"%.2f %%", Seg1Vtoss_3200kg ];
            
        }
         */
        
        //NSLog(@"***seg1Percent  %.0f", seg1Percent);

        
        // segement 2 Clmb
        
        
        /*
        // this is ClmbGrad_<3200kg
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"Seg2Vtoss_3200kg"].location != NSNotFound   ) {
            if (i == 6) {
                Seg2Vtoss_3200kg = [[resultsAllChartValues objectAtIndex: i  ] floatValue];
               
            }
        }
        
        // this is ClmbGrad_3700kg
        if ([[resultsAllChartNames objectAtIndex: i  ] rangeOfString:@"Seg2Vtoss_3700kg"].location != NSNotFound  ) {
            if (i == 7) {
                Seg2Vtoss_3700kg = [[resultsAllChartValues objectAtIndex: i  ] floatValue];
                
            }
        }
        */
        
        
        
        
        
    }
    
    
  
 
    
    
    
    
    _interpolatedSeg2OEIMCPGrad.text = [[NSString alloc] initWithFormat:@"%.2f %%", Seg2Vtoss_Selected ];
    
   
    
    
    //NSLog(@"Seg2Vtoss_Selected  %.3f", Seg2Vtoss_Selected);
    //NSLog(@"Seg2Vtoss_3700kg  %.3f", Seg2Vtoss_3700kg);
    
  
   
    
    _seg2Distance.text = [[NSString alloc] initWithFormat:@"%.0f m",  ((800.0 / Seg2Vtoss_Selected ) * 100) * 0.3048     ];
    
    _catAClearHeliSgement2Distance.text = _seg2Distance.text;
    _catAClearHeliSgement1Distance.text = _seg1Distance.text;
    
    _catAClearHeliTOTALDIstance.text = [[NSString alloc] initWithFormat:@"%.0f m", [_chContTOdist.text floatValue] + [_chAccelDist.text floatValue] +  [_seg1Distance.text floatValue]  + [_seg2Distance.text floatValue]   ];
    
    _catAVTOLTOTALDIstance.text = [[NSString alloc] initWithFormat:@"%.0f m", [_labelContinuedTODist.text floatValue] + [_VTOLAccelerationDistance.text floatValue] +  [_seg1Distance.text floatValue]  + [_seg2Distance.text floatValue]   ];
    
    
    if ([_VTOLMaxMassCeiling.text floatValue] < Hp) {
        _VTOLMaxMassCeiling.textColor = [UIColor redColor];
        
    }else{
        
      _VTOLMaxMassCeiling.textColor = GreenColor;
        
    }
    
    
    
    // PC2 **********************************************
    _PC2PIS8.text = _seg1Percent.text;
    
    flagPC2error = 0;
    
    if ([_seg1Percent.text floatValue] < 8.0) {
        _PC2PIS8.textColor = [UIColor redColor]; flagPC2error = 1;
    }else{
         _PC2PIS8.textColor = GreenColor;
    }
    _PC2CeilingMTOM.text = _AEOHOGETOP.text;
    
    PC2ceiling = [_PC2CeilingMTOM.text floatValue];
    
    
    if ([_PC2CeilingMTOM.text floatValue] < Hp) {
        _PC2CeilingMTOM.textColor = [UIColor redColor]; flagPC2error = 1;
    }else{
        _PC2CeilingMTOM.textColor = GreenColor;
    }
    
    
    _PC2OEIROC150.text = _interpolatedSeg2OEIMCPGrad.text;
    
    if ([_PC2OEIROC150.text floatValue] < 2.12) {
        _PC2OEIROC150.textColor = [UIColor redColor]; flagPC2error = 1;
    }else{
        _PC2OEIROC150.textColor = GreenColor;
    }
    
    
    
    
    _labelCurrentACweight.text = [[NSString alloc] initWithFormat:@"%.0f kg", unchangedACWeight ];
    
    _labelFuelWeight.text = [[NSString alloc] initWithFormat:@"%.0f kg", fuelWeight ];
    
    _labelDensityAlt.text = [[NSString alloc] initWithFormat:@"%.0f ft", DensityAlt ];

    
    _MTOWcorrectionPenalty.text = [[NSString alloc] initWithFormat:@"%.0f kg", penaltyWeight ];
    _HeightGainCorrectionPenalty.text = [[NSString alloc] initWithFormat:@"%.2f ft/100ft", penaltyFtMin ];
    
    _MTOWcorrectionPenalty2.text = [[NSString alloc] initWithFormat:@"%.0f kg", penaltyWeight ];
    _HeightGainCorrectionPenalty2.text = [[NSString alloc] initWithFormat:@"%.2f ft/100ft", penaltyFtMin ];
    
    
    _MTOWcorrectionPenalty3.text = [[NSString alloc] initWithFormat:@"%.0f kg", penaltyWeight ];
    _HeightGainCorrectionPenalty3.text = [[NSString alloc] initWithFormat:@"%.2f ft/100ft", penaltyFtMin ];
    
    
    _addGain2Vy.text = [[NSString alloc] initWithFormat:@"%.2f %%", addGain2Vy ];
    
    _catAEnRouteOEIMCPCeiling.text = [[NSString alloc] initWithFormat:@"%.0f ft", CATAenRouteOEIMCP ];
    
    // do interpolations
    
    float acWeightForInterpolation = acWeight;
    if (acWeightForInterpolation < 3200) {
        acWeightForInterpolation = 3200;
    }
    
    if (acWeightForInterpolation > 3700) {
        acWeightForInterpolation = 3700;
    }

    
    
}


- (void)drawRect:(CGRect)rect {
    /* Set UIView Border */
    /*
     // Get the contextRef
     CGContextRef contextRef = UIGraphicsGetCurrentContext();
     
     // Set the border width
     CGContextSetLineWidth(contextRef, 5.0);
     
     // Set the border color to RED
     CGContextSetRGBStrokeColor(contextRef, 255.0, 0.0, 0.0, 1.0);
     
     // Draw the border along the view edge
     CGContextStrokeRect(contextRef, rect);
     */
    
    /* Draw a circle */
    // Get the contextRef
    CGContextRef contextRef = UIGraphicsGetCurrentContext();
    
    // Set the border width
    CGContextSetLineWidth(contextRef, 1.0);
    
    // Set the circle fill color to GREEN
    CGContextSetRGBFillColor(contextRef, 0.0, 255.0, 0.0, 1.0);
    
    // Set the cicle border color to BLUE
    CGContextSetRGBStrokeColor(contextRef, 0.0, 0.0, 255.0, 1.0);
    
    // Fill the circle with the fill color
    CGContextFillEllipseInRect(contextRef, rect);
    
    // Draw the circle border
    CGContextStrokeEllipseInRect(contextRef, rect);
}



- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(actionNotificationMakeScreenshotPC2:) 
                                                 name:@"notificationMakeScreenshotPC2"
                                               object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(actionNotificationMakeScreenshotCATA:) 
                                                 name:@"notificationMakeScreenshotCATA"
                                               object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(actionNotificationMakeScreenshotCATA2:) 
                                                 name:@"notificationMakeScreenshotCATA2"
                                               object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(actionNotificationMakeScreenshotDONE:) 
                                                 name:@"notificationMakeScreenshotDONE"
                                               object:nil];
    
    
    float crossSize = 50;
    float dotSize = 40;
    
    float dotLineWidth = 3.0;
    
    _viewVTOL.hidden = YES; _viewCATACH.hidden = NO;
    
    // make cross views
    
    
    viewCross1 = [[UIView alloc] initWithFrame: CGRectMake ( 300, 50, crossSize, crossSize)];
    [_viewChartsUniversal addSubview:viewCross1];
    //viewCross1.backgroundColor =[UIColor yellowColor];
    
    viewCross2 = [[UIView alloc] initWithFrame: CGRectMake ( 300, 150, crossSize, crossSize)];
    [_viewChartsUniversal addSubview:viewCross2];
    //viewCross2.backgroundColor = [UIColor yellowColor];
    
    viewCross3 = [[UIView alloc] initWithFrame: CGRectMake ( 300, 250, crossSize, crossSize)];
    [_viewChartsUniversal addSubview:viewCross3];
    //viewCross3.backgroundColor = [UIColor yellowColor];
    
    viewCross4 = [[UIView alloc] initWithFrame: CGRectMake ( 300, 350, crossSize, crossSize)];
    [_viewChartsUniversal addSubview:viewCross4];
    //viewCross4.backgroundColor = [UIColor yellowColor];
    
    
    
    circleLayer = [CAShapeLayer layer];
    [circleLayer setBounds:CGRectMake(0.0f, 0.0f, crossSize , crossSize )];
    [circleLayer setPosition:CGPointMake( crossSize/2, crossSize/2)];
    
    // Create a circle path.
    pathC = [UIBezierPath bezierPathWithOvalInRect:   CGRectMake((crossSize/2) - (dotSize/2), (crossSize/2) - (dotSize/2), dotSize, dotSize)]; // xPos,yPos width, height
    [circleLayer setPath:[pathC CGPath]];
    [circleLayer setStrokeColor:[ colorSet CGColor]  ];
    [circleLayer setFillColor:[[UIColor clearColor] CGColor]];
    [circleLayer setLineWidth:dotLineWidth];
    [viewCross1.layer addSublayer:circleLayer];
    
 
    CAShapeLayer *circleLayer2 = [CAShapeLayer layer];
    [circleLayer2 setBounds:CGRectMake(0.0f, 0.0f, crossSize , crossSize )];
    [circleLayer2 setPosition:CGPointMake( crossSize/2, crossSize/2)];
    pathC = [UIBezierPath bezierPathWithOvalInRect:   CGRectMake((crossSize/2) - (dotSize/2), (crossSize/2) - (dotSize/2), dotSize, dotSize)]; // xPos,yPos width, height
    [circleLayer2 setPath:[pathC CGPath]];
    [circleLayer2 setStrokeColor:[ colorSet CGColor]  ];
    [circleLayer2 setFillColor:[[UIColor clearColor] CGColor]];
    [circleLayer2 setLineWidth:dotLineWidth];
    [viewCross2.layer addSublayer:circleLayer2];
 
   
    
    CAShapeLayer *circleLayer3 = [CAShapeLayer layer];
    [circleLayer3 setBounds:CGRectMake(0.0f, 0.0f, crossSize , crossSize )];
    [circleLayer3 setPosition:CGPointMake( crossSize/2, crossSize/2)];
    pathC = [UIBezierPath bezierPathWithOvalInRect:   CGRectMake((crossSize/2) - (dotSize/2), (crossSize/2) - (dotSize/2), dotSize, dotSize)]; // xPos,yPos width, height
    [circleLayer3 setPath:[pathC CGPath]];
    [circleLayer3 setStrokeColor:[ colorSet CGColor]  ];
    [circleLayer3 setFillColor:[[UIColor clearColor] CGColor]];
    [circleLayer3 setLineWidth:dotLineWidth];
    [viewCross3.layer addSublayer:circleLayer3];
    
    
    
    CAShapeLayer *circleLayer4 = [CAShapeLayer layer];
    [circleLayer4 setBounds:CGRectMake(0.0f, 0.0f, crossSize , crossSize )];
    [circleLayer4 setPosition:CGPointMake( crossSize/2, crossSize/2)];
    pathC = [UIBezierPath bezierPathWithOvalInRect:   CGRectMake((crossSize/2) - (dotSize/2), (crossSize/2) - (dotSize/2), dotSize, dotSize)]; // xPos,yPos width, height
    [circleLayer4 setPath:[pathC CGPath]];
    [circleLayer4 setStrokeColor:[ colorSet CGColor]  ];
    [circleLayer4 setFillColor:[[UIColor clearColor] CGColor]];
    [circleLayer4 setLineWidth:dotLineWidth];
    [viewCross4.layer addSublayer:circleLayer4];
    
    
    
    
    
    UIPinchGestureRecognizer *twoFingerPinch = [[UIPinchGestureRecognizer alloc]
                                                initWithTarget:self
                                                action:@selector(twoFingerPinch:)]
    ;
    
    [[self masterViewCharts] addGestureRecognizer:twoFingerPinch];
    
    
    
    
    
    UIPanGestureRecognizer *panRecognizer = [[UIPanGestureRecognizer alloc]
                                             initWithTarget:self
                                             action:@selector(panRecognizer:)]
    ;
    
    [[self viewChartContainer] addGestureRecognizer:panRecognizer];
    
    
    
    UITapGestureRecognizer *singleTapRecognizer = [[UITapGestureRecognizer alloc]
                                                   initWithTarget: self
                                                   action:@selector(handleSingleTapOnView:)];
    
    [singleTapRecognizer setNumberOfTouchesRequired:1];
    [[self masterViewCharts] addGestureRecognizer: singleTapRecognizer];
    

    
    
    //NSLog(@"viewDidLoad calcPerfClass");
    
    moveupDown = 0, moveLeftRight = 0, pinchScale = 1, pinchScaleEnded = 1;
    fullScreenPerfCharts = 0;
    
    transferValueDictionary = [[NSMutableDictionary alloc] init];
  
    resultsAllChartNames = [[NSMutableArray alloc] init];
    resultsAllChartUserNames= [[NSMutableArray alloc] init];
    resultsAllChartValues = [[NSMutableArray alloc] init];
    resultsAllUnits = [[NSMutableArray alloc] init];
    
    
    
    
    // load basics
    
    serverUrl  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"serverUrl"];
    ACCategory  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"ACCategory"];
    ACmanufacturer  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"ACmanufacturer"];
    AC_Type  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"AC_Type"];
    ACVariant  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"ACVariant"];

  
    
    //importPerfData *_importPerfData = [[importPerfData alloc]init];
    //[_importPerfData loadDataFromDisk];
    //[_importPerfData checkIfPerfDataIsLoaded];

    chartImagesDictionary = [[NSMutableDictionary alloc] init];
    
    
    
    
    [self calcPerformance];
    
    
   
    
    acWeight = 2500;
    
    headWindKTS = 0;
    
    
}


- (void)actionNotificationMakeScreenshotPC2:(NSNotification *)notification {
    
    //NSLog(@"actionNotificationMakeScreenshotPC2");
    
    _viewCATAOverview3.hidden = NO; // PC2
    
    _viewCATAOverview2.hidden = YES; // VTOL und Clear Heli
   
    [_viewChartContainer bringSubviewToFront:_viewCATAOverview3];
    
    
    
}


- (void)actionNotificationMakeScreenshotCATA:(NSNotification *)notification {
    
    //NSLog(@"actionNotificationMakeScreenshotCATA");
    
    _switchCATAVTOL.hidden = YES;
   
     _viewCATAOverview3.hidden = YES; // PC2
     _viewCATAOverview2.hidden = NO; // VTOL und Clear Heli
    
    [_viewChartContainer bringSubviewToFront:_viewCATAOverview2];
    
    _viewVTOL.hidden = YES;
    _viewCATACH.hidden = NO;
    
    
}

- (void)actionNotificationMakeScreenshotCATA2:(NSNotification *)notification {
    
    //NSLog(@"actionNotificationMakeScreenshotCATA2");
    
    _switchCATAVTOL.hidden = YES;
    
    _viewCATAOverview3.hidden = YES; // PC2
    _viewCATAOverview2.hidden = NO; // VTOL und Clear Heli
    
    [_viewChartContainer bringSubviewToFront:_viewCATAOverview2];
    
    _viewVTOL.hidden = NO;
    _viewCATACH.hidden = YES;
    
   
    
    
    
}

- (void)actionNotificationMakeScreenshotDONE:(NSNotification *)notification {
    
    //NSLog(@"actionNotificationMakeScreenshotDONE");
    
    _switchCATAVTOL.hidden = NO;
    
    
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}




- (void) calcPerformance {
    
    specialChart = @"";
    
    if ([AC_Type isEqualToString:@"H145"]) {
        //NSLog(@"calc 1");
        [self calcPerformanceH145];
        [self calcMixedCG];
        [self calcDriftDown];
    }else{
        //NSLog(@"calc 2");
        [self calcPerformanceActual];
        
    }
    
    //NSLog(@"calc 3");
    
}



- (void) calcPerformanceH145{
    
    
    float currentOAT = OAT;
    float currentPA = Hp;
    
    totalCeilingSteps1 = 0;
    totalCeilingSteps2 = 0;
    totalCeilingSteps3 = 0;
    totalCeilingSteps4 = 0;
    totalCeilingStepsOLD = 0;
    
    //NSLog(@"start perf H145 Rega ************************ ");
    
    [self calcPerformanceActual];
    
    
    OEIMCPGrad3000 = 0; // 2000 ft ISA
    OEIMCPGrad4000 = 0; // 3000 ft ISA
    OEIMCPGrad5000 = 0; // 4000 ft ISA
    
    
    
    float acWeightForInterpolation = acWeight;
    if (acWeightForInterpolation < 3200) {
        acWeightForInterpolation = 3200;
    }
    if (acWeightForInterpolation > 3700) {
        acWeightForInterpolation = 3700;
    }
    
 
    // 2000ft ISA = OEIMCPGrad3000
    
    //NSLog(@"ISADiff %.1f ", ISADiff);
    // get OAT in relation to ISA:
    
    Hp = 2000;    
    OAT = 11 + ISADIFFCelsius;
    _labelOATat2000.text = [[NSString alloc] initWithFormat:@"OAT at 2000' = %.1fºC", OAT ];
    specialChart = @"Heli_Airbus_H145_NONE_Seg2Vtoss_3200kg_Sup911_FigA16";
    [self calcPerformanceActual];
    OEIMCPGrad3000 = resultComputation;
    OEIMCPGrad3000 = OEIMCPGrad3000 + penaltyFtMin;
    
    
    // 3000ft ISA = OEIMCPGrad4000
    Hp = 3000;
    OAT = 9 + ISADIFFCelsius;
    _labelOATat3000.text = [[NSString alloc] initWithFormat:@"OAT at 3000' = %.1fºC", OAT ];
    specialChart = @"Heli_Airbus_H145_NONE_Seg2Vtoss_3200kg_Sup911_FigA16";
    [self calcPerformanceActual];
    OEIMCPGrad4000 = resultComputation;
    OEIMCPGrad4000 = OEIMCPGrad4000 + penaltyFtMin;
    
    
    
    // 4000ft ISA  = OEIMCPGrad5000
    Hp = 4000;
    OAT = 7 + ISADIFFCelsius;
    _labelOATat4000.text = [[NSString alloc] initWithFormat:@"OAT at 4000' = %.1fºC", OAT ];
    specialChart = @"Heli_Airbus_H145_NONE_Seg2Vtoss_3200kg_Sup911_FigA16";
    [self calcPerformanceActual];
    OEIMCPGrad5000 = resultComputation;
    OEIMCPGrad5000 = OEIMCPGrad5000 + penaltyFtMin;

    
    
    _interpolatedSeg2ORIMCPGrad3000.text = [[NSString alloc] initWithFormat:@"%.2f %%", OEIMCPGrad3000 ];
    _interpolatedSeg2ORIMCPGrad4000.text = [[NSString alloc] initWithFormat:@"%.2f %%", OEIMCPGrad4000 ];
    _interpolatedSeg2ORIMCPGrad5000.text = [[NSString alloc] initWithFormat:@"%.2f %%", OEIMCPGrad5000 ];
    
    
    Hp = currentPA;
    OAT = currentOAT;
    
    //NSLog(@"totalCeilingSteps1 %d", totalCeilingSteps1);
    //NSLog(@"totalCeilingSteps2 %d", totalCeilingSteps2);
    //NSLog(@"totalCeilingSteps3 %d", totalCeilingSteps3);
    //NSLog(@"totalCeilingSteps4 %d", totalCeilingSteps4);
    //NSLog(@"combine total %d", totalCeilingSteps1 + totalCeilingSteps2 + totalCeilingSteps3 + totalCeilingSteps4);
    //NSLog(@"totalCeilingStepsOLD %d", totalCeilingStepsOLD);
    
 
    [self calcModifiedTOPath];
    
    
    
}




- (void) calcPerformanceActual {
    
  
    
    //NSLog(@"class calcPerformance ");
    // load basics
    
    serverUrl  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"serverUrl"];
    ACCategory  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"ACCategory"];
    ACmanufacturer  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"ACmanufacturer"];
    AC_Type  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"AC_Type"];
    ACVariant  = [[NSUserDefaults standardUserDefaults]  stringForKey: @"ACVariant"];
    
    float flagIsLandscape = 1;
    
    if (fullScreenPerfCharts == 0 & flagIsLandscape == 1) {
        _masterViewCharts.frame = CGRectMake( 0, 0, 644, 632 ); // landscape
    }
    if (fullScreenPerfCharts == 1 & flagIsLandscape == 1) {
        _masterViewCharts.frame = CGRectMake( 0, 0, 1024, 690 ); // landscape full screen
    }
    if (fullScreenPerfCharts == 0 & flagIsLandscape == 0) {
        _masterViewCharts.frame = CGRectMake( 0, 0, 644, 628 ); // portrait
    }
    if (fullScreenPerfCharts == 1 & flagIsLandscape == 0) {
        _masterViewCharts.frame = CGRectMake( 0, 0, 768, 950 ); // portrait full screen
    }
    
    
    // **********************************************************************************************************************************************************************************************************
    // **********************************************************************************************************************************************************************************************************
    // START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START
    // START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START    START
    // **********************************************************************************************************************************************************************************************************
    // **********************************************************************************************************************************************************************************************************
    
    if ([specialChart isEqualToString:@""]) {
        
        [resultsAllChartNames removeAllObjects];
        [resultsAllChartUserNames removeAllObjects];
        [resultsAllChartValues removeAllObjects];
        [resultsAllUnits removeAllObjects];
        
        //NSLog(@"computing ----------------------");
        //NSLog(@"ACCategory %@", ACCategory);
        //NSLog(@"ACmanufacturer %@", ACmanufacturer);
        //NSLog(@"AC_Type %@", AC_Type);
        
        //1. get amount of available charts to compute
        arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@_%@_%@_%@", ACCategory, ACmanufacturer, AC_Type, ACVariant, @"availableCharts" ];
        chartsArray = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
        
        //NSLog(@"1 chartsArray %@", chartsArray);
        
        numberOfChartsForThisAircraft = (int)chartsArray.count;
        
        //NSLog(@"1 numberOfChartsForThisAircraft = %d  ******************************", numberOfChartsForThisAircraft  );
        
        actualButtonNumber = 0;
        
        _viewCATAOverview1.hidden = YES;
        _viewCATAOverview2.hidden = YES;
        _viewCATAOverview3.hidden = YES;
        _viewCATAOverview4.hidden = YES;
        _viewMixedCG.hidden = YES;
        _viewDriftDown.hidden = YES;
        
    }else{
        
        //NSLog(@" do special chart %@ ", specialChart);
        
    }
    
   
    
    
    
    
    
    //2. loop all charts
    for (nChart =0; nChart<numberOfChartsForThisAircraft; nChart++) {
        
       
        // check if you need to use a weight penalty
        acWeight = unchangedACWeight;
        
        
      
        
       
        
        
        // add penatly for ceilings
        if ([[chartsArray objectAtIndex:nChart]  rangeOfString:@"MaxMass_Sup911_FigB1_CX"].location != NSNotFound    ) {
            
            //NSLog(@"1 acWeight %.0f ", acWeight);
            //NSLog(@"adding penalty to acWeight  %.0f ", penaltyWeight);
            acWeight = unchangedACWeight - penaltyWeight;
            //NSLog(@"2 acWeight %.0f ", acWeight);
        }
        
        
        if ([[chartsArray objectAtIndex:nChart]  rangeOfString:@"MaxMass_VTOL_Sup911_FigC4_CX"].location != NSNotFound    ) {
            
            //NSLog(@"1 acWeight %.0f ", acWeight);
            //NSLog(@"adding penalty to acWeight  %.0f ", penaltyWeight);
            acWeight = unchangedACWeight - penaltyWeight;
            //NSLog(@"2 acWeight %.0f ", acWeight);
        }
        
    
        
       
        
        
        
        _MTOWcorrected.text = [[NSString alloc] initWithFormat:@"%.0f kg", unchangedACWeight - penaltyWeight ];

        
        
        if (![specialChart isEqualToString:@""]) {
            
            if (![[chartsArray objectAtIndex:nChart] isEqualToString:specialChart]) {
                //NSLog(@"continue **************** nChart %d ", nChart);
                continue;
            }else{

                //NSLog(@"I am doing this  **************** nChart %d ", nChart);
                //NSLog(@"I am doing chartNameForThisInfoFile %@ ", [chartsArray objectAtIndex:nChart]);
            }
        }
        
        
        
        //NSLog(@"**** nChart %d ", nChart);        
        
        actualButtonNumber = actualButtonNumber +1;
        [self getInfoForCurrentChart];
        
        // check dependency
        int numberOfChartsToCombine = 0;
        NSString *criteria;
        float criteriaValue = 0;
        float criteriaValueMid1= 0;
        float criteriaValueMid2= 0;
        
        
        // check if this is a ceiling computation i.e. "1 part ceiling"
        flagCeilingComputation = 0;
        
        
        //NSLog(@"infoArray %@ ", infoArray);
        
        
        
        if ([[infoArray objectAtIndex:2]  rangeOfString:@"Ceiling"].location != NSNotFound    ) {
            flagCeilingComputation = 1;
        }
        
        if ([[infoArray objectAtIndex:2]  rangeOfString:@"CeilingROC"].location != NSNotFound    ) {
            flagCeilingComputation = 2;
        }
        
        
        
        if ([ [infoArray objectAtIndex:3]  rangeOfString:@"next3"].location != NSNotFound      ) {
            numberOfChartsToCombine = 3;
            // get criteria
            if ([ [infoArray objectAtIndex:4]  rangeOfString:@"acWeight"].location != NSNotFound      ) {
                criteria = @"acWeight";
                criteriaValueMid1 = [[infoArray objectAtIndex:5] floatValue];
                criteriaValueMid2 = [[infoArray objectAtIndex:6] floatValue];
                //NSLog(@"criteriaValueMid1 %.0f", criteriaValueMid1);
                //NSLog(@"criteriaValueMid2 %.0f", criteriaValueMid2);
                criteriaValue = acWeight;
                //NSLog(@"criteriaValue TOW %.0f", criteriaValue);
            }
            
            
        }else if ([ [infoArray objectAtIndex:3]  rangeOfString:@"next2"].location != NSNotFound      ) {
            
            numberOfChartsToCombine = 2;
            // get criteria
            if ([ [infoArray objectAtIndex:4]  rangeOfString:@"acWeight"].location != NSNotFound      ) {
                criteria = @"acWeight";
                criteriaValueMid1 = [[infoArray objectAtIndex:5] floatValue];
                criteriaValueMid2 = [[infoArray objectAtIndex:6] floatValue];
                //NSLog(@"1 criteriaValueMid1 %.0f", criteriaValueMid1);
                //NSLog(@"criteriaValueMid2 %.0f", criteriaValueMid2);
                criteriaValue = acWeight;
                //NSLog(@"1 criteriaValue TOW %.0f", criteriaValue);
            }
            
        }else if ([ [infoArray objectAtIndex:3]  rangeOfString:@"Custom"].location != NSNotFound      ) {
            numberOfChartsToCombine = 0;
        }
        else{
            numberOfChartsToCombine = 1;
        }
        
        
        //NSLog(@"numberOfChartsToCombine %d ", numberOfChartsToCombine);
        
        
        // CUSTOM CHART **** **** **** **** **** **** **** **** **** **** **** **** **** **** **** **** ****
        if (numberOfChartsToCombine == 0) {
            
            //NSLog(@"CUSTOM CHART **** **** **** **** **** **** **** **** **** **** ");
            unitResult = @"-";
            resultComputation = 999999;
            [resultsAllChartNames addObject: chartNameForThisInfoFile];
            [resultsAllChartUserNames addObject: chartUserName];
            [resultsAllChartValues addObject: [ [NSString alloc] initWithFormat:@"%.5f", resultComputation ]];
            [resultsAllUnits addObject:unitResult];
            
            //NSLog(@"chartUserName %@", chartUserName);
            chartNumberForResult = nChart;
            [self writeButtonLabels];
            
            if (selectedChartButton == actualButtonNumber) {
                
                if (nChart == 0) {
                    _viewCATAOverview1.hidden = NO;
                }
                if (nChart == 1) {
                    _viewCATAOverview2.hidden = NO;
                }
                if (nChart == 2) {
                    _viewCATAOverview3.hidden = NO;
                }
                if (nChart == 3) {
                    _viewMixedCG.hidden = NO;
                }
                if (nChart == 4) {
                    _viewDriftDown.hidden = NO;
                }
                chartNameToLoad = chartNameForThisInfoFile;
            }
        }
        
        
        
        // one chart only no combinations, no interpoalations **** **** **** **** **** **** **** **** **** **** **** **** **** **** **** **** ****
        if (numberOfChartsToCombine == 1) {
            //NSLog(@"do only one chart"  );
            //NSLog(@"1 nChart %d", nChart);
            //NSLog(@"flagCeilingComputation %d", flagCeilingComputation);
            
            if (flagCeilingComputation == 0) {
              
                //sdf
                if ([chartNameForThisInfoFile isEqualToString:@"Heli_Airbus_H145_NONE_HELIONIX_5_47_RoC_OEI_MCP_3700kg"]) {
                    
                 
                    //NSLog(@"-----");
                    float hpMerker = Hp;
                    float OATmerker = OAT;
                    
                    float SCueberhoehung = [_lUeberhoehungTotal.text floatValue];
                    //Hp = 8000.0 + SCueberhoehung;
                    
                    Hp = [_lMEA1plusGeschUeberhoehung.text floatValue];
                    
                    float calcisa = 15 - (1.98 * ((8000.0 + SCueberhoehung)/1000));
                    OAT = calcisa+ISADiff;
                    
                    //NSLog(@"sending Hp  = %.0f ", Hp);
                    //NSLog(@"sending OAT = %.0f ", OAT);
                    
                    [self getInfoForCurrentChart];
                    [self loopAllPartsAndSaveResults];
                    
                    //NSLog(@"RoC OEI MCP 1 %.0f ", resultComputation);
                    
                    resultHoehenverlusst = resultComputation;
                    
                    //NSLog(@"1resultHoehenverlusst %.0f ", resultHoehenverlusst);
                    
                    chartNumberForResult = nChart;
                    [self writeButtonLabels];
                    
                    
                    //mea 2
                    
                    SCueberhoehung = [_lUeberhoehungTotalMEA2.text floatValue];
                    //Hp = 8000.0 + SCueberhoehung;
                    Hp = [_lMEA2plusGeschUeberhoehung.text floatValue];
                    
                    calcisa = 15 - (1.98 * ((8000.0 + SCueberhoehung)/1000));
                    OAT = calcisa+ISADiff;
                    
                    //NSLog(@"sending Hp  = %.0f ", Hp);
                    //NSLog(@"sending OAT = %.0f ", OAT);
                    
                    [self getInfoForCurrentChart];
                    [self loopAllPartsAndSaveResults];
                    
                    //NSLog(@"RoC OEI MCP 2 %.0f ", resultComputation);
                    
                    resultHoehenverlusstMEA2 = resultComputation;
                    
                    chartNumberForResult = nChart;
                    [self writeButtonLabels];
                    
                    
                    Hp = hpMerker;
                    OAT = OATmerker;
                    
                    
                
                    
                    
                    
                    
                }else{
                   
                    [self loopAllPartsAndSaveResults]; 
                    chartNumberForResult = nChart;
                    [self writeButtonLabels];
            
                }
              
            }else{
                
                float maxCeilingValue = 20000;
                float minCeilingValue = 0;
                
                if (infoArray.count >4) {
                    maxCeilingValue = [[infoArray objectAtIndex:3] floatValue];
                    minCeilingValue = [[infoArray objectAtIndex:4] floatValue];
                    //NSLog(@"maxCeilingValue  %.0f", maxCeilingValue);
                    //NSLog(@"minCeilingValue  %.0f", minCeilingValue);
                }
               
                
                // calc ceiling
                minResult = 0;
                maxResult = 9999;
                float hpMerker = Hp;
                float OATmerker = OAT;
                
                // fine tune
                float maxAlt1 = 0;
                float maxAlt2 = 0;
                float maxAlt3 = 0;
                
               
                for (int i = 1; i < 50; i++) {
                    totalCeilingSteps1 = totalCeilingSteps1 + 1;
                    Hp = maxCeilingValue - ( i * 5000);
                    if (Hp <= minCeilingValue) {
                        Hp = minCeilingValue;
                    }
                    // get temperature for PA
                    float tempISAatSimElevation = 15 - ( 1.98 * (Hp / 1000)  );
                    OAT = tempISAatSimElevation + ISADiff;
                    [self getInfoForCurrentChart];
                    [self loopAllPartsAndSaveResults];
                    
                    // OGE / IGE ceiling
                    if (resultComputation > acWeight || Hp <= minCeilingValue ) {
                        float paCalc = ((29.92 - altimeterInches) *1000 );
                        maxAlt1 = Hp - paCalc +5000 ;
                        //NSLog(@"maxAlt1   %f", maxAlt1 );
                        break;
                    }
                }
                
              
                for (int i = 1; i < 450; i++) {
                    totalCeilingSteps2 = totalCeilingSteps2 + 1;
                    Hp = maxAlt1 - ( i * 1000);
                    if (Hp <= minCeilingValue) {
                        Hp = minCeilingValue;
                    }
                    // get temperature for PA
                    float tempISAatSimElevation = 15 - ( 1.98 * (Hp / 1000)  );
                    OAT = tempISAatSimElevation + ISADiff;
                    [self getInfoForCurrentChart];
                    [self loopAllPartsAndSaveResults];
                    // OGE / IGE ceiling
                    if (resultComputation > acWeight || Hp <= minCeilingValue) {
                        float paCalc = ((29.92 - altimeterInches) *1000 );
                        maxAlt2 = Hp - paCalc +1000 ;
                        //NSLog(@"maxAlt2   %f", maxAlt2 );
                        break;
                    }
                }
                
                
                
                for (int i = 1; i < 450; i++) {
                    
                    totalCeilingSteps3 = totalCeilingSteps3 + 1;
                    Hp = maxAlt2 - ( i * 200);
                    if (Hp <= minCeilingValue) {
                        Hp = minCeilingValue;
                    }
                    // get temperature for PA
                    float tempISAatSimElevation = 15 - ( 1.98 * (Hp / 1000)  );
                    OAT = tempISAatSimElevation + ISADiff;
                    [self getInfoForCurrentChart];
                    [self loopAllPartsAndSaveResults];
                    // OGE / IGE ceiling
                    if (resultComputation > acWeight || Hp <= minCeilingValue) {
                        float paCalc = ((29.92 - altimeterInches) *1000 );
                          maxAlt3 = Hp - paCalc + 200;
                         //NSLog(@"maxAlt3   %f", maxAlt3 );
                         //NSLog(@"CEILING MSL   %f", resultComputation );
                        break;
                    }
                }
                
             
                for (int i = 1; i < 450; i++) {
                    
                    totalCeilingSteps4 = totalCeilingSteps4 + 1;
                    
                    Hp = maxAlt3 - ( i * 50);
                    if (Hp <= minCeilingValue) {
                        Hp = minCeilingValue;
                    }
                    // get temperature for PA
                    float tempISAatSimElevation = 15 - ( 1.98 * (Hp / 1000)  );
                    OAT = tempISAatSimElevation + ISADiff;
                    [self getInfoForCurrentChart];
                    [self loopAllPartsAndSaveResults];
                    // OGE / IGE ceiling
                    if (resultComputation > acWeight || Hp <= minCeilingValue) {
                        float paCalc = ((29.92 - altimeterInches) *1000 );
                        resultComputation = Hp - paCalc ;
                        //NSLog(@"CEILING MSL   %f", resultComputation );
                        break;
                    }
                }
                Hp = hpMerker;
                OAT = OATmerker;
                [resultsAllChartNames addObject: chartNameForThisInfoFile];
                [resultsAllChartUserNames addObject: chartUserName];
                [resultsAllChartValues addObject: [ [NSString alloc] initWithFormat:@"%.5f", resultComputation ]];
                [resultsAllUnits addObject:unitResult];
                chartNumberForResult = nChart;
                [self writeButtonLabels];
                
                
            }
            
            if (selectedChartButton == actualButtonNumber) {
                
                
                chartNameToLoad = chartNameForThisInfoFile;
                
                [self drawCrossesAndLines];
                [self loadChartImage];
            }
        }
        
        
        
        // two charts, no interpoalations **** **** **** **** **** **** **** **** **** **** **** **** **** **** **** **** ****
        
        if (numberOfChartsToCombine == 2) {
            //NSLog(@"do the next two charts"  );
            
            //1
            if (flagCeilingComputation == 0) {
                [self loopAllPartsAndSaveResults];
            }
            
          
            
            
            if (flagCeilingComputation == 2) {
                
                //NSLog(@"222222222  + ceiling");
                
                // calc ceiling
                minResult = 0;
                maxResult = 9999;
                float hpMerker = Hp;
                float OATmerker = OAT;
                for (int i = 1; i < 450; i++) {
                    Hp = 20000 - ( i * 100);
                    // get temperature for PA
                    float tempISAatSimElevation = 15 - ( 1.98 * (Hp / 1000)  );
                    OAT = tempISAatSimElevation + ISADiff;
                    [self getInfoForCurrentChart];
                    [self loopAllPartsAndSaveResults];
                    //NSLog(@"resultComputation %.0f ", resultComputation);
                    
                    // ROC Ceiling
                    if (resultComputation > 50.0) {
                        float paCalc = ((29.92 - altimeterInches) *1000 );
                        resultComputation = Hp - paCalc ;
                        //NSLog(@"1 ROC CEILING MSL   %f", resultComputation );
                        break;
                    }
                }
                
                Hp = hpMerker;
                OAT = OATmerker;
                [resultsAllChartNames addObject: chartNameForThisInfoFile];
                [resultsAllChartUserNames addObject: chartUserName];
                [resultsAllChartValues addObject: [ [NSString alloc] initWithFormat:@"%.5f", resultComputation ]];
                [resultsAllUnits addObject:unitResult];
            }
            
            //NSLog(@"show chart depening on criteria");

            //NSLog(@"criteriaValue %.0f", criteriaValue);
            //NSLog(@"criteriaValueMid1 %.0f", criteriaValueMid1);
            
            float result1 = 0;
            float result2 = 0;
            
            
            // show chart depening on criteria
            if (selectedChartButton == actualButtonNumber & criteriaValue <= criteriaValueMid1  ) {
                //NSLog(@"1 ??");
                chartNameToLoad = chartNameForThisInfoFile;
                [self drawCrossesAndLines];
                [self loadChartImage];
            }
            
            result1 = resultComputation;
            
            //2
            nChart ++;
            [self getInfoForCurrentChart];
            if (flagCeilingComputation == 0) {
                [self loopAllPartsAndSaveResults];
            }
            if (flagCeilingComputation == 2) {
                // calc ceiling
                minResult = 0;
                maxResult = 9999;
                float hpMerker = Hp;
                float OATmerker = OAT;
                
                for (int i = 1; i < 450; i++) {
                    Hp = 20000 - ( i * 100);
                    // get temperature for PA
                    float tempISAatSimElevation = 15 - ( 1.98 * (Hp / 1000)  );
                    OAT = tempISAatSimElevation + ISADiff;
                    [self getInfoForCurrentChart];
                    [self loopAllPartsAndSaveResults];
                    
                    // ROC Ceiling
                    if (resultComputation > 50.0) {
                        float paCalc = ((29.92 - altimeterInches) *1000 );
                        resultComputation = Hp - paCalc ;
                        //NSLog(@"2 ROC CEILING MSL   %f", resultComputation );
                        break;
                    }
                }
                
                Hp = hpMerker;
                OAT = OATmerker;
                [resultsAllChartNames addObject: chartNameForThisInfoFile];
                [resultsAllChartUserNames addObject: chartUserName];
                [resultsAllChartValues addObject: [ [NSString alloc] initWithFormat:@"%.5f", resultComputation ]];
                [resultsAllUnits addObject:unitResult];
            }
            
            
            if (selectedChartButton == actualButtonNumber & criteriaValue > criteriaValueMid1   ) {
                //NSLog(@"2 ??");
                chartNameToLoad = chartNameForThisInfoFile;
                [self drawCrossesAndLines];
                [self loadChartImage];
            }
            
            
            result2 = resultComputation;
            
            //NSLog(@"criteriaValue %.0f", criteriaValue);
            //NSLog(@"criteriaValueMid1 %.0f", criteriaValueMid1);
            // now make decison what chart has result and what chart is to display
            
            
            
            if (criteriaValue <= criteriaValueMid1  ) {
                chartNumberForResult  = nChart -1;
                resultComputation = result1;
            }
            
            if (criteriaValue > criteriaValueMid1 ) {
                chartNumberForResult  = nChart;
                resultComputation = result2;
            }
            
            [self writeButtonLabels];
            
            
        }// end compute two charts
        
        
        
        
        // three combined charts ROC etc...  **** **** **** **** **** **** **** **** **** **** **** **** **** **** **** **** ****
        
        if (numberOfChartsToCombine == 3) {
            //NSLog(@"do the next three charts"  );
            
            //1
            [self loopAllPartsAndSaveResults];
            // show chart depening on criteria
            
            if (selectedChartButton == actualButtonNumber & criteriaValue <= criteriaValueMid1  ) {
                
                //NSLog(@"1 ??");
                
                chartNameToLoad = chartNameForThisInfoFile;
                
                [self drawCrossesAndLines];
                [self loadChartImage];
            }
            
            //2
            nChart ++;
            [self getInfoForCurrentChart];
            [self loopAllPartsAndSaveResults];
            
            
            
            if (selectedChartButton == actualButtonNumber & criteriaValue > criteriaValueMid1 & criteriaValue <= criteriaValueMid2   ) {
                
                //NSLog(@"2 ??");
                chartNameToLoad = chartNameForThisInfoFile;
                
                [self drawCrossesAndLines];
                [self loadChartImage];
            }
            
            
            //3
            nChart ++;
            [self getInfoForCurrentChart];
            [self loopAllPartsAndSaveResults];
            
            
            
            if (selectedChartButton == actualButtonNumber & criteriaValue > criteriaValueMid2   ) {
                
                //NSLog(@"3 ??");
                chartNameToLoad = chartNameForThisInfoFile;
                
                [self drawCrossesAndLines];
                [self loadChartImage];
            }
            
            
            
            // now make decison what chart has result and what chart is to display
            if (criteriaValue <= criteriaValueMid1  ) {
                chartNumberForResult  = nChart -2;
            }
            
            if (criteriaValue > criteriaValueMid1 & criteriaValue <= criteriaValueMid2 ) {
                chartNumberForResult  = nChart -1;
            }
            
            if (criteriaValue > criteriaValueMid2 ) {
                chartNumberForResult  = nChart;
            }
            
            [self writeButtonLabels];
            
            
            
        }// end compute two charts
        
    }// end do all charts
    
    
    //NSLog(@"transferValueDictionary %@", transferValueDictionary);
    
    //NSLog(@"resultsAllCharts %@ , %@", resultsAllChartNames, resultsAllChartValues);
    
    
    
  
    [[NSUserDefaults standardUserDefaults]  setObject:resultsAllChartValues       forKey:@"resultsAllChartValues" ];
    [[NSUserDefaults standardUserDefaults]  setObject:resultsAllChartUserNames       forKey:@"resultsAllChartUserNames" ];
    
    //NSLog(@"saving resultsAllCharts %@ ", resultsAllChartUserNames);
    
    
}


- (void) getInfoForCurrentChart {
    
    //NSLog(@"getInfoForCurrentChart ");
    
    // get info for next chart *****************************************************************************
    chartNameForThisInfoFile = [chartsArray objectAtIndex:nChart];
    //NSLog(@"next chart to do = %@", chartNameForThisInfoFile  );
    arrayKey = [ [NSString alloc] initWithFormat:@"%@_%@",  chartNameForThisInfoFile, @"infoGeneral" ];
    infoArray = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
    //NSLog(@"general infoArray = %@", infoArray );
    
    //NSLog(@"2 getInfoForCurrentChart ");
    numberOfComputationParts = [[infoArray objectAtIndex:2] intValue] ;
    //NSLog(@"numberOfComputationParts = %d", numberOfComputationParts );
    chartUserName = [infoArray objectAtIndex:1];
    
    limitationsForHoist = [infoArray objectAtIndex:2];
    //NSLog(@"3getInfoForCurrentChart ");
}

- (void) loopAllPartsAndSaveResults {
    
    //NSLog(@"loopAllPartsAndSaveResults **********************");
    
    for (partNumberToCompute =1; partNumberToCompute<numberOfComputationParts+1; partNumberToCompute++) {
        //NSLog(@"compute %@_part%d", chartNameForThisInfoFile, partNumberToCompute);
        
        infoPartNumber = partNumberToCompute;
        [self getInfoFileForThisPart];
        
        [self getInputForCurveAndAxis];
        
        [self checkInputDataRange];
        
        [self calcComputation];
        
        [self limitResultValues];
        
        //NSLog(@"compute %@_part%d  result %f ", chartNameForThisInfoFile, partNumberToCompute, resultComputation);
        
        
        if (flagThisPartResultContainsTransferValue == 1) {
            
            NSString *transferValueText =  [ [NSString alloc] initWithFormat:@"%.5f", resultComputation ];
            NSString *saveTextForDictionary =  [ [NSString alloc] initWithFormat:@"%@_part%d", chartNameForThisInfoFile, partNumberToCompute ];
            [transferValueDictionary setObject:transferValueText  forKey:saveTextForDictionary];
            //float transferValTest  = [[transferValueDictionary objectForKey:saveTextForDictionary] floatValue];
            //NSLog(@"saving transferVal for chart: %@ part %d in dictionary %.3f ", chartNameForThisInfoFile, partNumberToCompute, transferValTest);
        }
    }
    
    if (flagCeilingComputation == 0) {
        // save chart results
        [resultsAllChartNames addObject: chartNameForThisInfoFile];
        [resultsAllChartUserNames addObject: chartUserName];
        [resultsAllChartValues addObject: [ [NSString alloc] initWithFormat:@"%.5f", resultComputation ]];
        [resultsAllUnits addObject:unitResult];
        
    }

    
    
    //NSLog(@"resultsAllChartNames %@ ", resultsAllChartNames);
    
    
}

- (void) writeButtonLabels {
    
    if (![specialChart isEqualToString:@""]) {
        //NSLog(@"NOT writeButtonLabels ");
        return;
    }
    
    //NSLog(@"writeButtonLabels ");
    
    resultFromComputations = [[resultsAllChartValues objectAtIndex:chartNumberForResult] floatValue];
    chartNameForComputation = [resultsAllChartNames objectAtIndex:chartNumberForResult] ;
    userNameForComputation = [resultsAllChartUserNames objectAtIndex:chartNumberForResult] ;
    unitNameForComputation = [resultsAllUnits objectAtIndex:chartNumberForResult] ;
    ViewController *parent = (ViewController *)self.parentViewController;
    
    //NSLog(@"- chartNameForComputation %@ ", chartNameForComputation);
    

    //NSLog(@"userNameForComputation %@  = %@", [resultsAllChartUserNames objectAtIndex:chartNumberForResult] ,   [resultsAllChartValues objectAtIndex:chartNumberForResult] ) ;
    
    
    if ([chartNameForComputation isEqualToString:@"Heli_Airbus_H145_NONE_EnRoute_OEI_MCP_Sup911_FigA25_CX"]) {
        
        resultOEIMCPCeiling =  [[resultsAllChartValues objectAtIndex:chartNumberForResult] floatValue];
        //NSLog(@"resultDriftDownServiceCeiling %f", resultDriftDownServiceCeiling);
    }

    // is now MCP_CLB_GRAD
    //Heli_Airbus_H145_NONE_Seg2Vtoss_3200kg_Sup911_FigA16
    if ([chartNameForComputation isEqualToString:@"Heli_Airbus_H145_NONE_Seg2Vtoss_3200kg_Sup911_FigA16"]) {
    //if ([[resultsAllChartUserNames objectAtIndex:chartNumberForResult] isEqualToString:@"ClmbGrad_<3200kg"]) { 
        //NSLog(@"2 chartNameForComputation %@ ", chartNameForComputation);
        float tempResult = [[resultsAllChartValues objectAtIndex:chartNumberForResult] floatValue];
        float resultWithPenalty = tempResult +  penaltyFtMin;
        [resultsAllChartValues replaceObjectAtIndex:chartNumberForResult withObject:[[NSString alloc] initWithFormat:@"%.2f", resultWithPenalty  ] ];
        resultFromComputations = resultWithPenalty;
        if (acWeight <=3200) {
            Seg2Vtoss_Selected = resultWithPenalty;
            //NSLog(@"<3200 Seg2Vtoss_Selected %.3f ", Seg2Vtoss_Selected);
        }
        //NSLog(@"new : userNameForComputation %@  = %@", [resultsAllChartUserNames objectAtIndex:chartNumberForResult] ,   [resultsAllChartValues objectAtIndex:chartNumberForResult]) ;

    }
    
    // is now MCP_CLB_GRAD was ClmbGrad
    //Heli_Airbus_H145_NONE_Seg2Vtoss_3700kg_Sup911_FigA15
    if ([chartNameForComputation isEqualToString:@"Heli_Airbus_H145_NONE_Seg2Vtoss_3700kg_Sup911_FigA15"]) {
    //if ([[resultsAllChartUserNames objectAtIndex:chartNumberForResult] isEqualToString:@"ClmbGrad_3700kg"]) {
        //NSLog(@"3 chartNameForComputation %@ ", chartNameForComputation);
        float tempResult = [[resultsAllChartValues objectAtIndex:chartNumberForResult] floatValue];
        
        float resultWithPenalty = tempResult +  penaltyFtMin;
        //NSLog(@"resultWithPenalty %.3f ", resultWithPenalty);
        [resultsAllChartValues replaceObjectAtIndex:chartNumberForResult withObject:[[NSString alloc] initWithFormat:@"%.2f", resultWithPenalty  ] ];
        resultFromComputations = resultWithPenalty;
        if (acWeight >3200) {
            Seg2Vtoss_Selected = resultWithPenalty;
            //NSLog(@">3200 Seg2Vtoss_Selected %.3f ", Seg2Vtoss_Selected);
        }
        
        //mixedCG
        resultCGMCPPercent = resultWithPenalty;
        //NSLog(@"new : userNameForComputation %@  = %@", [resultsAllChartUserNames objectAtIndex:chartNumberForResult] ,   [resultsAllChartValues objectAtIndex:chartNumberForResult]) ;
        
      
        
    }
    
    // is now 2mP CLB GRAD   was ClmbGrad 2min Vy
    if ([chartNameForComputation isEqualToString:@"Heli_Airbus_H145_NONE_HeightGainVy_Sup911_FigA23"]) {
    //if ([[resultsAllChartUserNames objectAtIndex:chartNumberForResult] isEqualToString:@"ClmbGrad_2min_Vy"]) {
        //NSLog(@"4 chartNameForComputation %@ ", chartNameForComputation);
        float tempResult = [[resultsAllChartValues objectAtIndex:chartNumberForResult] floatValue];
       
        //NSLog(@"tempResult %f", tempResult); 
        
        float resultWithPenalty = tempResult +  penaltyFtMin;
        
        //NSLog(@"resultWithPenalty %.3f ", resultWithPenalty);
        [resultsAllChartValues replaceObjectAtIndex:chartNumberForResult withObject:[[NSString alloc] initWithFormat:@"%.2f", resultWithPenalty  ] ];
        resultFromComputations = resultWithPenalty;
      
        //mixedCG
        resultCG2minPercent = resultWithPenalty;
        
        //NSLog(@"resultCG2minPercent %f", resultCG2minPercent); 
              
              
        //NSLog(@"new : userNameForComputation %@  = %@", [resultsAllChartUserNames objectAtIndex:chartNumberForResult] ,   [resultsAllChartValues objectAtIndex:chartNumberForResult]) ;
        
        
    }
    
    if ([[resultsAllChartUserNames objectAtIndex:chartNumberForResult] isEqualToString:@"Seg1_Vt<3200kg"]) {
        float tempResult = [[resultsAllChartValues objectAtIndex:chartNumberForResult] floatValue];
        float resultWithPenalty = tempResult +  penaltyFtMin;
        //NSLog(@"resultWithPenalty %.3f ", resultWithPenalty);
        [resultsAllChartValues replaceObjectAtIndex:chartNumberForResult withObject:[[NSString alloc] initWithFormat:@"%.2f", resultWithPenalty  ] ];
        resultFromComputations = resultWithPenalty;
        //NSLog(@"new : userNameForComputation %@  = %@", [resultsAllChartUserNames objectAtIndex:chartNumberForResult] ,   [resultsAllChartValues objectAtIndex:chartNumberForResult]) ;
        if (acWeight <=3200) {
            Seg1Vtoss_Selected = resultWithPenalty;
            //NSLog(@"<3200 Seg1Vtoss_Selected %.3f ", Seg1Vtoss_Selected);
        }
        
    }
    
    if ([[resultsAllChartUserNames objectAtIndex:chartNumberForResult] isEqualToString:@"Seg1_Vt"]) {
        float tempResult = [[resultsAllChartValues objectAtIndex:chartNumberForResult] floatValue];
        //NSLog(@"tempResult %.3f ", tempResult);
        //NSLog(@"penaltyFtMin %.2f ", penaltyFtMin);
        float resultWithPenalty = tempResult +  penaltyFtMin;
        //NSLog(@"resultWithPenalty %.3f ", resultWithPenalty);
        [resultsAllChartValues replaceObjectAtIndex:chartNumberForResult withObject:[[NSString alloc] initWithFormat:@"%.2f", resultWithPenalty  ] ];
        resultFromComputations = resultWithPenalty;
        if (acWeight >3200) {
            Seg1Vtoss_Selected = resultWithPenalty;
             //NSLog(@"> 3200 Seg1Vtoss_Selected %.3f ", Seg1Vtoss_Selected);
        }

        //NSLog(@"new : userNameForComputation %@  = %@", [resultsAllChartUserNames objectAtIndex:chartNumberForResult] ,   [resultsAllChartValues objectAtIndex:chartNumberForResult]) ;
        
    }

    
    //|Heli_Airbus_H145_NONE_MaxMass_Sup911_FigB1, CH_MTOM, 1 part,
    if ([[resultsAllChartUserNames objectAtIndex:chartNumberForResult] isEqualToString:@"CH_MTOM"]) {
        float tempResult = [[resultsAllChartValues objectAtIndex:chartNumberForResult] floatValue];
        //NSLog(@"tempResult CH_MTOM %.3f ", tempResult);
        //NSLog(@"penaltyWeight %.2f ", penaltyWeight);
        float resultWithPenalty = tempResult +  penaltyWeight;
        //NSLog(@"resultWithPenalty %.3f ", resultWithPenalty);
        if (resultWithPenalty > 3700) {
            resultWithPenalty = 3700;
        }
        [resultsAllChartValues replaceObjectAtIndex:chartNumberForResult withObject:[[NSString alloc] initWithFormat:@"%.2f", resultWithPenalty  ] ];
        resultFromComputations = resultWithPenalty;
        //NSLog(@"new : userNameForComputation %@  = %@", [resultsAllChartUserNames objectAtIndex:chartNumberForResult] ,   [resultsAllChartValues objectAtIndex:chartNumberForResult]) ;
        
    }
    
    
    //|Heli_Airbus_H145_NONE_MaxMass_VTOL_Sup911_FigC4, VTOL_MTOM , 1 part,
    //Heli_Airbus_H145_NONE_MaxMass_VTOL_Sup911_FigC4_CX, VTOL_MTOM _Ceiling, 1 part Ceiling, 20000, -1500,
    if ([[resultsAllChartUserNames objectAtIndex:chartNumberForResult] isEqualToString:@"VTOL_MTOM"]) {
        float tempResult = [[resultsAllChartValues objectAtIndex:chartNumberForResult] floatValue];
        //NSLog(@"tempResult CH_MTOM %.3f ", tempResult);
        //NSLog(@"penaltyWeight %.2f ", penaltyWeight);
        float resultWithPenalty = tempResult +  penaltyWeight;
        //NSLog(@"resultWithPenalty %.3f ", resultWithPenalty);
        if (resultWithPenalty > 3700) {
            resultWithPenalty = 3700;
        }
        [resultsAllChartValues replaceObjectAtIndex:chartNumberForResult withObject:[[NSString alloc] initWithFormat:@"%.2f", resultWithPenalty  ] ];
        resultFromComputations = resultWithPenalty;
        //NSLog(@"new : userNameForComputation %@  = %@", [resultsAllChartUserNames objectAtIndex:chartNumberForResult] ,   [resultsAllChartValues objectAtIndex:chartNumberForResult]) ;
        
    }
    
    
    //|Heli_Airbus_H145_NONE_MaxMass_VTOL_Training_Sup911_FigD1, VTOL_MTOM_Training, 1 part,
    if ([[resultsAllChartUserNames objectAtIndex:chartNumberForResult] isEqualToString:@"VTOL_MTOM_Training"]) {
        float tempResult = [[resultsAllChartValues objectAtIndex:chartNumberForResult] floatValue];
        //NSLog(@"tempResult CH_MTOM %.3f ", tempResult);
        //NSLog(@"penaltyWeight %.2f ", penaltyWeight);
        float resultWithPenalty = tempResult +  penaltyWeight;
        //NSLog(@"resultWithPenalty %.3f ", resultWithPenalty);
        if (resultWithPenalty > 3700) {
            resultWithPenalty = 3700;
        }
        [resultsAllChartValues replaceObjectAtIndex:chartNumberForResult withObject:[[NSString alloc] initWithFormat:@"%.2f", resultWithPenalty  ] ];
        resultFromComputations = resultWithPenalty;
        //NSLog(@"new : userNameForComputation %@  = %@", [resultsAllChartUserNames objectAtIndex:chartNumberForResult] ,   [resultsAllChartValues objectAtIndex:chartNumberForResult]) ;
        
    }



    
    
    //|Heli_Airbus_H145_NONE_EnRoute_OEI_MCP_Sup911_FigA25, OEI_MCP, 1 part,
    if ([[resultsAllChartUserNames objectAtIndex:chartNumberForResult] isEqualToString:@"OEI_MCP"]) {
        float tempResult = [[resultsAllChartValues objectAtIndex:chartNumberForResult] floatValue];
        //NSLog(@"tempResult OEI_MCP %.3f ", tempResult);
        //NSLog(@"penaltyWeight %.2f ", penaltyWeight);
        float resultWithPenalty = tempResult +  penaltyWeight;
        //NSLog(@"1 resultWithPenalty %.3f ", resultWithPenalty);
        if (resultWithPenalty > 3700) {
            resultWithPenalty = 3700;
        }
        //NSLog(@"2 resultWithPenalty %.3f ", resultWithPenalty);
        [resultsAllChartValues replaceObjectAtIndex:chartNumberForResult withObject:[[NSString alloc] initWithFormat:@"%.2f", resultWithPenalty  ] ];
        resultFromComputations = resultWithPenalty;
        //NSLog(@"new : userNameForComputation %@  = %@", [resultsAllChartUserNames objectAtIndex:chartNumberForResult] ,   [resultsAllChartValues objectAtIndex:chartNumberForResult]) ;
        
    }
    
    
    
    
    
    
    
    
    
    if ([unitNameForComputation isEqualToString:@"lbs"]) {
        unitNameForComputation = @"kg";
        resultFromComputations = resultFromComputations / 2.2046;
        //NSLog(@"convert resultFromComputations  %f to kg: %f", resultFromComputations, resultFromComputations / 2.2046 );
    }
    
    
    dL = [[UILabel alloc] init];  dL = (UILabel *)[ parent.self.viewUniversalButtons viewWithTag:   actualButtonNumber + 100  ];
    dL.text = userNameForComputation;
    dL.text  = [ dL.text stringByReplacingOccurrencesOfString:@"_" withString:@" "];
    
    // check warnings
    dL = [[UILabel alloc] init];  dL = (UILabel *)[parent.self.viewUniversalButtons viewWithTag:   actualButtonNumber + 200  ];
    
    // check if percent, then add one digit for precision
    if ([unitNameForComputation rangeOfString:@"%"].location != NSNotFound ){
        float altDiff = 0;
        float VTossKIAS = 0;
        
        
        if ([unitNameForComputation isEqualToString:@"%GradH145"] ){
            //NSLog(@"1");
            dL.text = [ [NSString alloc] initWithFormat:@"%.2f%%", cross3ValueX  ];
            
            //NSLog(@"cross2ValueX %f", cross2ValueX);
            
            //NSLog(@"cross3ValueX %f", cross3ValueX);
            
            //NSLog(@"resultFromComputations %f", resultFromComputations);
        }
        
        
        if ([unitNameForComputation isEqualToString:@"%Grad"] ){
            //NSLog(@"2");
            altDiff = 165;
            VTossKIAS = 50;
            // compute horizontal distance to climb from 35 to 200 feet at 50 KIAS
            //fpm = Gradient * Speed
            float gradient = resultFromComputations;
            float fpm = gradient * VTossKIAS;
            float timeNeededForClimbMinutes = altDiff / fpm;
            float distanceAtVTOSSinNM = VTossKIAS * timeNeededForClimbMinutes / 60;
            float distanceInFeet = distanceAtVTOSSinNM * 6076.12;
            //dL.text = [ [NSString alloc] initWithFormat:@"%.1f %@", resultFromComputations, unitNameForComputation  ];
            dL.text = [ [NSString alloc] initWithFormat:@"%.1f%% = %.0f ft", resultFromComputations, distanceInFeet  ];
        }
        
        if ([unitNameForComputation isEqualToString:@"%Grad800"] ){
            //NSLog(@"3");
            altDiff = 800;
            VTossKIAS = 60;
            // compute horizontal distance to climb from 35 to 200 feet at 50 KIAS
            //fpm = Gradient * Speed
            float gradient = resultFromComputations;
            float fpm = gradient * VTossKIAS;
            float timeNeededForClimbMinutes = altDiff / fpm;
            float distanceAtVTOSSinNM = VTossKIAS * timeNeededForClimbMinutes / 60;
            float distanceInFeet = distanceAtVTOSSinNM * 6076.12;
            //dL.text = [ [NSString alloc] initWithFormat:@"%.1f %@", resultFromComputations, unitNameForComputation  ];
            dL.text = [ [NSString alloc] initWithFormat:@"%.1f%% = %.0f ft", resultFromComputations, distanceInFeet  ];
        }
        
        if ([unitNameForComputation isEqualToString:@"%Path"] ){
            //NSLog(@"4");
            dL.text = [ [NSString alloc] initWithFormat:@"%.1f%%", resultFromComputations  ];
            
        }
        
    }else if ([unitNameForComputation rangeOfString:@"TV"].location != NSNotFound ){
        dL.text = [ [NSString alloc] initWithFormat:@"%.2f %@", resultFromComputations, unitNameForComputation  ];
        
    }else{
        
        
        /*
        if ([chartNameForComputation rangeOfString:@"MaxMass_Sup911_FigB1"].location != NSNotFound & [chartNameForComputation rangeOfString:@"CX"].location == NSNotFound ) {
            
            resultFromComputations = resultFromComputations + penaltyWeight;
        }
      
        
       
        if ([chartNameForComputation rangeOfString:@"MaxMass_VTOL_Sup911_FigC4"].location != NSNotFound & [chartNameForComputation rangeOfString:@"CX"].location == NSNotFound ) {
            
            resultFromComputations = resultFromComputations + penaltyWeight;
        }
        
        if ([chartNameForComputation rangeOfString:@"MaxMass_VTOL_Training_Sup911_FigD1"].location != NSNotFound & [chartNameForComputation rangeOfString:@"CX"].location == NSNotFound ) {
            
            resultFromComputations = resultFromComputations + penaltyWeight;
        }
        */
        
        
        
        dL.text = [ [NSString alloc] initWithFormat:@"%.0f %@", resultFromComputations, unitNameForComputation  ];
        
        
        
        if (resultFromComputations == 999999) {
            dL.text = [ [NSString alloc] initWithFormat:@"%@",  unitNameForComputation  ];
            
            if (nChart == 0) {
                dL.text = @"Performance";
            }
            
            if (nChart == 1) {
                dL.text = @"CAT.A";
            }
            
            if (nChart == 2) {
                dL.text = @"PC2e";
            }
            
            if (nChart == 3) {
                dL.text = @"AVG CLB GRAD";
            }
            if (nChart == 4) {
                dL.text = @"Drift Down";
            }
        }
        
    }
    
    
    if (flagInputDataOutOfRange > 0) {
        dL.text = @"> Range";
    }
    
    if ([userNameForComputation rangeOfString:@"H-V_Diagram"].location != NSNotFound        ){
        if (resultFromComputations < 40) {
            dL.text = @"No H-V Area";
        }
    }
    
    
    
    dL = [[UILabel alloc] init];  dL = (UILabel *)[parent.self.viewUniversalButtons viewWithTag:   actualButtonNumber + 300  ];
    dL.text = chartNameForComputation;
    
    
    
    
    UIImage *buttonRed = [UIImage imageNamed:@"button_red.png"];
    UIImage *buttonGrey = [UIImage imageNamed:@"button grey top184x52.png"];
    UIImage *buttonBlue = [UIImage imageNamed:@"button blue top184x52.png"];
    
    flagDrawACweightLines = 0;
    
    if ([limitationsForHoist rangeOfString:@"limitsHoist"].location != NSNotFound ){
        
        [parent.self.arrayExternalLoadRestrictions addObject:[ [NSString alloc] initWithFormat:@"%.2f", resultFromComputations] ];
        //NSLog(@"adding %@ ", [ [NSString alloc] initWithFormat:@"%.2f", resultFromComputations] );
        //NSLog(@"parent.self.arrayExternalLoadRestrictions %@ ", parent.self.arrayExternalLoadRestrictions );
    }
    
    
    // || [userNameForComputation rangeOfString:@"OEI_MCP_Ceil"].location != NSNotFound
    
    
    //NSLog(@"chartNumberForResult %@ ", chartNumberForResult );
    
    
    
    
    if ([userNameForComputation rangeOfString:@"MCP_CLB_GRAD"].location != NSNotFound  ) {
        
        if (resultFromComputations < 5.0) {
            UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
            [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateNormal];
            [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateSelected];
            
            triangleTrigger = 1;
            
        }else{
            UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
            [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateNormal];
            if ( [buttonToWarn isSelected ]) {
                [buttonToWarn setBackgroundImage:buttonBlue forState:UIControlStateSelected];
            }else{
                [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateSelected];
            }
        }
    }
    
    
    
    
    
    if ([userNameForComputation rangeOfString:@"2mP_CLB_GRAD"].location != NSNotFound) {
        
        //NSLog(@"ClmbGrad_2min_Vy %.2f ", resultFromComputations );
        
        if (resultFromComputations < 5.0) {
            UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
            [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateNormal];
            [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateSelected];
            triangleTrigger = 1;
            
        }else{
            UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
            [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateNormal];
            if ( [buttonToWarn isSelected ]) {
                [buttonToWarn setBackgroundImage:buttonBlue forState:UIControlStateSelected];
            }else{
                [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateSelected];
            }
        }
    }
    
    
    
    
    
    
    
    
    
    
    if ([userNameForComputation rangeOfString:@"AEO_HOGE_TOP_Ceiling"].location != NSNotFound
        || [userNameForComputation rangeOfString:@"OEI_HIGE_2min_Ceiling"].location != NSNotFound
        || [userNameForComputation rangeOfString:@"OEI_MCP_Ceiling"].location != NSNotFound
       
        
        ){
        
        
        if (flagCeilingComputation == 0) {
            
            flagDrawACweightLines = 1;
            if (DensityAlt > resultFromComputations) {
                UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
                [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateNormal];
                [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateSelected];
                
            }else{
                UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
                [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateNormal];
                if ( [buttonToWarn isSelected ]) {
                    [buttonToWarn setBackgroundImage:buttonBlue forState:UIControlStateSelected];
                }else{
                    [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateSelected];
                }
            }
        }
        
  
        
        if (flagCeilingComputation == 1 ) {
            // it's an OGE/IGE ceiling computation!
            flagDrawACweightLines = 1;
            if (DensityAlt > resultFromComputations) {
                UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
                [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateNormal];
                [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateSelected];
                
                triangleTrigger = 1;
                
            }else{
                UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
                [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateNormal];
                if ( [buttonToWarn isSelected ]) {
                    [buttonToWarn setBackgroundImage:buttonBlue forState:UIControlStateSelected];
                }else{
                    [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateSelected];
                }
            }
        }
        
        
        
    }// emd if OGE, IGE or WAT
    
    
    if ([userNameForComputation rangeOfString:@"RoC"].location != NSNotFound     ){
        
        if (flagCeilingComputation == 2) {
            // it's a ROC ceiling computation!
            flagDrawACweightLines = 1;
            if (resultFromComputations < Hp) {
                UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
                [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateNormal];
                [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateSelected];
            }else{
                UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: actualButtonNumber ];
                [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateNormal];
                if ( [buttonToWarn isSelected ]) {
                    [buttonToWarn setBackgroundImage:buttonBlue forState:UIControlStateSelected];
                }else{
                    [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateSelected];
                }
            }
        }
        
        
    }
    
    
    return;
    
    
    
}






- (void) drawCrossesAndLines {
    
    //NSLog(@"drawCrossesAndLines ********* ");
    
    viewCross2.hidden = YES;
    viewCross3.hidden = YES;
    viewCross4.hidden = YES;
    
   
    
    [_viewLinesOnChart.layer.sublayers makeObjectsPerformSelector:@selector(removeFromSuperlayer)]; // delete old lines
    
    
    //NSLog(@"newWPDdataAvialable %d " , newWPDdataAvialable);
    
    for (nCross =1; nCross<numberOfComputationParts+1; nCross++) {
        infoPartNumber = nCross;
        [self getInfoFileForThisPart];
        
        
        if (newWPDdataAvialable == 1) {
            
            xPix1 = [[infoPartArray objectAtIndex:25] floatValue];
            xPix2 = [[infoPartArray objectAtIndex:26] floatValue];
            xPix3 = [[infoPartArray objectAtIndex:29] floatValue];
            
            yPix1 = [[infoPartArray objectAtIndex:27] floatValue];
            yPix2 = [[infoPartArray objectAtIndex:28] floatValue];
            yPix3 = [[infoPartArray objectAtIndex:30] floatValue];
            
            
            chartWidthPixel = [[infoPartArray objectAtIndex:23] floatValue];
            chartHeightPixel = [[infoPartArray objectAtIndex:24] floatValue];
            
            xLeftChart = [[infoPartArray objectAtIndex:17] floatValue]; // min Input
            yBottomChart = [[infoPartArray objectAtIndex:19] floatValue]; // min Result
            xRightChart = [[infoPartArray objectAtIndex:18] floatValue]; // max Input
            yTopChart = [[infoPartArray objectAtIndex:20] floatValue]; // max Result
            
        }else{
            
            chartWidthPixel = [[infoPartArray objectAtIndex:23] floatValue];
            chartHeightPixel = [[infoPartArray objectAtIndex:24] floatValue];
            
            xLeftChart = [[infoPartArray objectAtIndex:17] floatValue]; // min Input
            yBottomChart = [[infoPartArray objectAtIndex:19] floatValue]; // min Result
            xRightChart = [[infoPartArray objectAtIndex:18] floatValue]; // max Input
            yTopChart = [[infoPartArray objectAtIndex:20] floatValue]; // max Result
            
            xLeftGC = [[infoPartArray objectAtIndex:31] floatValue];
            yBottomGC = [[infoPartArray objectAtIndex:32] floatValue];
            xRightGC = [[infoPartArray objectAtIndex:33] floatValue];
            yTopGC = [[infoPartArray objectAtIndex:34] floatValue];
            
            xposition = ((chartWidthPixel/10 * xLeftGC * (chartWidthInApp / chartWidthPixel))) + (((((chartWidthPixel/10 * xRightGC * (chartWidthInApp / chartWidthPixel))) - ((chartWidthPixel/10 * xLeftGC * (chartWidthInApp / chartWidthPixel))))/((xRightChart - xLeftChart))) * (Xinput  - xLeftChart)) ;
            
            yposition = ((chartHeightPixel - (chartHeightPixel/10 * yBottomGC)) * (chartHeightInApp / chartHeightPixel)) + (((((chartHeightPixel - (chartHeightPixel/10 * yTopGC)) * (chartHeightInApp / chartHeightPixel)) - ((chartHeightPixel - (chartHeightPixel/10 * yBottomGC)) * (chartHeightInApp / chartHeightPixel)))/(yTopChart - yBottomChart)) * (Yinput - yBottomChart)) ;
            
            //NSLog(@"xposition %.3f ", xposition);
            //NSLog(@"yposition %.3f ", yposition);
            
        }
        
        
        //NSLog(@"cross1ValueX %.0f ", cross1ValueX);
        
        //NSLog(@"cross1ValueY %.0f ", cross1ValueY);
      
        
        if (nCross == 1) {
            Xinput = cross1ValueX;
            Yinput = cross1ValueY;
            [self computeChartSizeInApp];
            _universalChartGraphic.frame = CGRectMake(0, 0, chartWidthInApp, chartHeightInApp);
            if (newWPDdataAvialable == 1) {
                [self drawLine];
            }
            
            //_crossUniversal1.center = CGPointMake( xposition, yposition);
            
            
            viewCross1.center = CGPointMake( xposition, yposition);
            
        }
        
        
        if (nCross == 2) {
            
            
            Xinput = cross2ValueX;
            Yinput = cross2ValueY;
            
            [self computeChartSizeInApp];
            
            _universalChartGraphic.frame = CGRectMake(0, 0, chartWidthInApp, chartHeightInApp);
            
            
            
            
            if (newWPDdataAvialable == 1) {
                [self drawLine];
            }
            
            
            viewCross2.hidden = NO;
            viewCross2.center = CGPointMake( xposition, yposition);
            
        }
        
        if (nCross == 3) {
            Xinput = cross3ValueX;
            Yinput = cross3ValueY;
            [self computeChartSizeInApp];
            _universalChartGraphic.frame = CGRectMake(0, 0, chartWidthInApp, chartHeightInApp);
            if (newWPDdataAvialable == 1) {
                [self drawLine];
            }
            viewCross3.hidden = NO;
            viewCross3.center = CGPointMake( xposition, yposition);
            
        }
        
        if (nCross == 4) {
            Xinput = cross4ValueX;
            Yinput = cross4ValueY;
            [self computeChartSizeInApp];
            _universalChartGraphic.frame = CGRectMake(0, 0, chartWidthInApp, chartHeightInApp);
            if (newWPDdataAvialable == 1) {
                [self drawLine];
            }
            viewCross4.hidden = NO;
            viewCross4.center = CGPointMake( xposition, yposition);
            
        }
        
        
        
        
        
    }
    
    
    
    
    
    
    
}




- (void) drawLine {
    
    
    // make lines
    
    
    
    //NSLog(@"drawLine *****************************");
    //NSLog(@"Xinput  %.0f ", Xinput);
    //NSLog(@"Yinput  %.0f ", Yinput);
    //NSLog(@"cross1ValueY  %.0f ", cross1ValueY);
    
    
    
    
    // x1 lines on chart
    
    float scaleFactorX = _universalChartGraphic.frame.size.width /  chartWidthPixel;
    float xPosX_pixel =  (xPix1)*Xinput + (xPix2)*Yinput+ (xPix3);
    xposition = xPosX_pixel * scaleFactorX;
    
    
    //NSLog(@"xPix1  %.10f ", xPix1);
    //NSLog(@"xPix2  %.10f ", xPix2);
    //NSLog(@"xPix3  %.10f ", xPix3);
    
    //NSLog(@"yPix1  %.10f ", yPix1);
    //NSLog(@"yPix2  %.10f ", yPix2);
    //NSLog(@"yPix3  %.10f ", yPix3);
    
    
    
    //NSLog(@"cross1ValueY  %.0f ", cross1ValueY);
    //NSLog(@"_universalChartGraphic.frame.size.width  %.0f ", _universalChartGraphic.frame.size.width);
    //NSLog(@"chartWidthPixel  %.0f ", chartWidthPixel);
    //NSLog(@"xposition  %.0f ", xposition);
    
    
    
    
    float yPosY_pixel = (yPix1)*Xinput + (yPix2)*Yinput + (yPix3);
    yposition = yPosY_pixel * scaleFactorX;

    
    
    //NSLog(@" (yPix1)*Xinput  %.0f ",  (yPix1)*Xinput);
    //NSLog(@" (yPix2)*Yinput %.0f ",  (yPix2)*Yinput  );
    //NSLog(@" (yPix3) %.0f ",   (yPix3) );
    //NSLog(@"yPosY_pixel  %.0f ", yPosY_pixel);
    //NSLog(@"yposition  %.0f ", yposition);
    
    
    
    
    
    
    
    _viewLinesOnChart.frame = CGRectMake(0, 0, _universalChartGraphic.frame.size.width, _universalChartGraphic.frame.size.height);
    
    _viewLinesOnChart.backgroundColor = [UIColor clearColor];
    
    
    
    NSString *lineDirectionFrom = [crossLineSequence substringToIndex:1];
  
    NSString *lineDirectionTO = [crossLineSequence substringFromIndex:2];
   
    
    
    
    if (yToX == 0) {
        
        
        // check if base left in the lower x values
        if ( (xPix1)*minInput + (xPix2)*Yinput+ (xPix3)  < (xPix1)*maxInput + (xPix2)*Yinput+ (xPix3) ) {
            // xAxis is normal (left = low right = high)
            //NSLog(@"XtoY *******  xAxis is normal  ");
            lineBaseLeftX =     minInput;
            lineBaseRightX =    maxInput;
        }else{
            //NSLog(@"XtoY *******  xAxis reversed ");
            lineBaseLeftX =     maxInput;
            lineBaseRightX =    minInput;
        }
        
        // check if base top is higher than base bottom
        
        if ( (yPix1)*Xinput + (yPix2)*minResult + (yPix3)  > (yPix1)*Xinput + (yPix2)*maxResult + (yPix3) ) {
            // yAxis is normal (left = low right = high)
            //NSLog(@"XtoY *******  yAxis is normal ");
            lineBaseBottomY =   minResult;
            lineBaseTopY =      maxResult;
        }else{
            //NSLog(@"XtoY *******  yAxis reversed ");
            lineBaseBottomY =   maxResult;
            lineBaseTopY =      minResult;
        }
        
        
        
        if ([lineDirectionFrom isEqualToString:@"b"]) {
            
            // we need to draw from bottom to cross
            float yPosY_pixel_lineBase = (yPix1)*Xinput + (yPix2)*lineBaseBottomY + (yPix3); // here is the base line for Y
            float yposition_lineBase = yPosY_pixel_lineBase * scaleFactorX;
            
            pathLine = [UIBezierPath bezierPath];
            [pathLine moveToPoint:CGPointMake( xposition, yposition_lineBase )]; // move to base
            [pathLine addLineToPoint:CGPointMake( xposition, yposition  )  ]; // from base to cross
            
        }
        
        if ([lineDirectionFrom isEqualToString:@"t"]) {
            
            // we need to draw from top to cross (lineBaseTopY)
            float yPosY_pixel_lineBase = (yPix1)*Xinput + (yPix2)*lineBaseTopY + (yPix3); // here is the base line for Y
            float yposition_lineBase = yPosY_pixel_lineBase * scaleFactorX;
            
            pathLine = [UIBezierPath bezierPath];
            [pathLine moveToPoint:CGPointMake( xposition, yposition_lineBase )]; // move to base
            [pathLine addLineToPoint:CGPointMake( xposition, yposition  )  ]; // from base to cross
            
        }
        
        
        
        if ([lineDirectionFrom isEqualToString:@"f"]) {
            
            //NSLog(@"special draw ");
            
            // prepare Y position
            float yPosY_pixel_lineBase = (yPix1)*1.0 + (yPix2)* drawToFixedPointY + (yPix3); // here is the base line for Y
            float yposition_FIX = yPosY_pixel_lineBase * scaleFactorX;
            
            // prepare X position
            float xPosX_pixel_lineBaseFix =  (xPix1)* drawToFixedPointX + (xPix2)*Yinput+ (xPix3); // here is the base line for X
            float xposition_FIX  = xPosX_pixel_lineBaseFix * scaleFactorX;
            
            
            pathLine = [UIBezierPath bezierPath];
            [pathLine moveToPoint:CGPointMake( xposition_FIX, yposition_FIX )]; // move to base
            [pathLine addLineToPoint:CGPointMake( xposition, yposition  )  ]; // from base to cross
            
        }
        
        // now draw to the left or to the right
        
        
        
        
        
        if ([lineDirectionTO isEqualToString:@"r"]) {
            
            float xPosX_pixel_lineBaseRightX =  (xPix1)*lineBaseRightX + (xPix2)*Yinput+ (xPix3); // here is the base line for X
            float xposition_lineBaseRightX  = xPosX_pixel_lineBaseRightX * scaleFactorX;
            [pathLine addLineToPoint:CGPointMake( xposition_lineBaseRightX, yposition )]; // from cross  to chart edge
            
        }else{
            
            
            
            float xPosX_pixel_lineBaseLeftX =  (xPix1)*lineBaseLeftX + (xPix2)*Yinput+ (xPix3); // here is the base line for X
            float xposition_lineBaseLeftX  = xPosX_pixel_lineBaseLeftX * scaleFactorX;
            [pathLine addLineToPoint:CGPointMake( xposition_lineBaseLeftX, yposition )]; // from cross  to chart edge
        }
        
        
        
        
        
        
        
        
    }
    
    if (yToX == 1) {
        
        
        //NSLog(@"minResult %.0f ", minResult);
        //NSLog(@"maxResult %.0f ", maxResult);
        //NSLog(@"minInput %.0f ", minInput);
        //NSLog(@"maxInput %.0f ", maxInput);
        
        
        
        // check if base left in the lower x values
        if ( (xPix1)*minResult + (xPix2)*Yinput+ (xPix3)  < (xPix1)*maxResult + (xPix2)*Yinput+ (xPix3) ) {
            // xAxis is normal (left = low right = high)
            //NSLog(@"yToX *******  xAxis is normal  ");
            lineBaseLeftX =     minResult;
            lineBaseRightX =    maxResult;
        }else{
            //NSLog(@"yToX *******  xAxis reversed ");
            lineBaseLeftX =     maxResult;
            lineBaseRightX =    minResult;
        }
        
        // check if base top is higher than base bottom
        
        if ( (yPix1)*Xinput + (yPix2)*minInput + (yPix3)  > (yPix1)*Xinput + (yPix2)*maxInput + (yPix3) ) {
            // yAxis is normal (left = low right = high)
            //NSLog(@"yToX *******  yAxis is normal ");
            lineBaseBottomY =   minInput;
            lineBaseTopY =      maxInput;
        }else{
            //NSLog(@"yToX *******  yAxis reversed ");
            lineBaseBottomY =   maxInput;
            lineBaseTopY =      minInput;
        }
        
        
        
        
        if ([lineDirectionFrom isEqualToString:@"l"]) {
            
            // we need to draw from left to cross
            
            float xPosX_pixel_lineBaseLeftX =  (xPix1)*lineBaseLeftX + (xPix2)*Yinput+ (xPix3); // here is the base line for X
            float xposition_lineBaseLeftX  = xPosX_pixel_lineBaseLeftX * scaleFactorX;
            
            pathLine = [UIBezierPath bezierPath];
            [pathLine moveToPoint:CGPointMake( xposition_lineBaseLeftX, yposition )]; // move to base
            [pathLine addLineToPoint:CGPointMake( xposition, yposition  )  ]; // from base to cross
            
        }else{
            
            // we need to draw from right to cross
            
            float xPosX_pixel_lineBaseRightX =  (xPix1)*lineBaseRightX + (xPix2)*Yinput+ (xPix3); // here is the base line for X
            float xposition_lineBaseRightX  = xPosX_pixel_lineBaseRightX * scaleFactorX;
            
            pathLine = [UIBezierPath bezierPath];
            [pathLine moveToPoint:CGPointMake( xposition_lineBaseRightX, yposition )]; // move to base
            [pathLine addLineToPoint:CGPointMake( xposition, yposition  )  ]; // from base to cross
            
            
        }
        
        
        // now draw to the top or bottom
        if ([lineDirectionTO isEqualToString:@"b"]) {
            // draw from cross to bottom
            
            float yPosY_pixel_lineBase = (yPix1)*Xinput + (yPix2)*lineBaseBottomY + (yPix3); // here is the base line for Y
            float yposition_lineBase = yPosY_pixel_lineBase * scaleFactorX;
            [pathLine addLineToPoint:CGPointMake( xposition, yposition_lineBase )]; // from cross  to chart edge
            
        }else{
            // draw from cross to top
            float yPosY_pixel_lineBase = (yPix1)*Xinput + (yPix2)*lineBaseTopY + (yPix3); // here is the base line for Y
            float yposition_lineBase = yPosY_pixel_lineBase * scaleFactorX;
            [pathLine addLineToPoint:CGPointMake( xposition, yposition_lineBase )]; // from cross  to chart edge
        }
        
    }
    
    
    
    
    
    
    markerPointX1 = xposition;
    
    CAShapeLayer *lineLayer = [CAShapeLayer layer];
    lineLayer.path = [pathLine CGPath];
    lineLayer.strokeColor = [colorSet CGColor];
    lineLayer.lineWidth = 3.0;
    lineLayer.fillColor = [[UIColor clearColor] CGColor];
    [_viewLinesOnChart.layer addSublayer:lineLayer];
    
    
    // draw line ACweight
    
    if (flagDrawACweightLines == 1 ) {
        
        if (flagOATisXaxis == 0) {
            //NSLog(@"acWeight  %.0f", acWeight);
            
            // we need to draw from top to bottom
            // this is the top
            float yPosY_pixel_lineBase = (yPix1)*Xinput + (yPix2)*lineBaseTopY + (yPix3);
            float yposition_lineBase = yPosY_pixel_lineBase * scaleFactorX;
            
            // this is the actual x position (ac weight)
            float xPosX_pixel_lineBaseRightX =  (xPix1)* (acWeight)  + (xPix2)*Yinput+ (xPix3);
            float xposition_lineBaseRightX  = xPosX_pixel_lineBaseRightX * scaleFactorX;
            
            // this is the bottom
            float yPosY_pixel_lineBase2 = (yPix1)*1.0 + (yPix2)* lineBaseBottomY + (yPix3);
            float yposition_FIX2 = yPosY_pixel_lineBase2 * scaleFactorX;
            
            
            pathLine = [UIBezierPath bezierPath];
            [pathLine moveToPoint:CGPointMake( xposition_lineBaseRightX, yposition_lineBase )];
            [pathLine addLineToPoint:CGPointMake( xposition_lineBaseRightX, yposition_FIX2  )  ];
            
            CAShapeLayer *lineLayer = [CAShapeLayer layer];
            lineLayer.path = [pathLine CGPath];
            lineLayer.strokeColor = [colorSetOrange CGColor];
            lineLayer.lineWidth = 3.0;
            lineLayer.fillColor = [[UIColor clearColor] CGColor];
            [_viewLinesOnChart.layer addSublayer:lineLayer];

        }else{
            
            //NSLog(@"flagOATisXaxis %.0f", OAT);
            // we need to draw from left to right at ac weight
            // this is the top
            
            // this is the actual y position (ac weight)
            float yPosY_pixel_lineBase = (yPix1)*Xinput + (yPix2)*acWeight + (yPix3);
            float yposition_lineBase = yPosY_pixel_lineBase * scaleFactorX;
            
            // this is left
            float xPosX_pixel_lineBaseLeftX =  (xPix1)*lineBaseLeftX + (xPix2)*Yinput+ (xPix3); // here is the base line for X
            float xposition_lineBaseLeftX  = xPosX_pixel_lineBaseLeftX * scaleFactorX;

            // this is right
            float xPosX_pixel_lineBaseRightX =  (xPix1)*lineBaseRightX + (xPix2)*Yinput+ (xPix3); // here is the base line for X
            float xposition_lineBaseRightX  = xPosX_pixel_lineBaseRightX * scaleFactorX;
            
            
            pathLine = [UIBezierPath bezierPath];
            [pathLine moveToPoint:CGPointMake( xposition_lineBaseLeftX, yposition_lineBase )];
            [pathLine addLineToPoint:CGPointMake( xposition_lineBaseRightX, yposition_lineBase  )  ];
            
            CAShapeLayer *lineLayer = [CAShapeLayer layer];
            lineLayer.path = [pathLine CGPath];
            lineLayer.strokeColor = [colorSetOrange CGColor];
            lineLayer.lineWidth = 3.0;
            lineLayer.fillColor = [[UIColor clearColor] CGColor];
            [_viewLinesOnChart.layer addSublayer:lineLayer];            
            
        }
        
        
    }

    
    
    return;
    
    
}


- (void) computeChartSizeInApp {
    
    //NSLog(@"computeChartSizeInApp _masterViewCharts.frame.size.width %.0f ", _masterViewCharts.frame.size.width);
    
    float leftBorderForChartContainer = 0;
    
    flagChartsFitToScreenHeight = 1;
    
    float ratioChartSize = chartWidthPixel / chartHeightPixel;
    
    if (chartWidthPixel > chartHeightPixel) {
        
        //NSLog(@"chart is landscape");
        
        chartHeightInApp = _masterViewCharts.frame.size.height ;
        
        chartWidthInApp = _masterViewCharts.frame.size.height * ratioChartSize;
        
        //NSLog(@"chartHeightInApp %.0f ", chartHeightInApp);
        
        //NSLog(@"chartWidthInApp %.0f ", chartWidthInApp);
        
        
        leftBorderForChartContainer = 0;
        
    }else{
        
        //NSLog(@"chart is portrait");
        
        chartHeightInApp = _masterViewCharts.frame.size.height ;
        
        chartWidthInApp = _masterViewCharts.frame.size.height * ratioChartSize;
        
        leftBorderForChartContainer = (_masterViewCharts.frame.size.width - chartWidthInApp)/2;
        
    }
    
    
    float xCenterMasterViewChart = _masterViewCharts.frame.size.width/2 - leftBorderForChartContainer;
    
    float yCenterMasterViewChart = _masterViewCharts.frame.size.height + ( 2 * pinchScale -1);
    
    _viewChartContainer.frame = CGRectMake(0 , 0, _masterViewCharts.frame.size.width , _masterViewCharts.frame.size.height);
    
    
    
    //_viewChartsUniversal.frame = CGRectMake(0 + moveLeftRight +leftBorderForChartContainer - (xCenterMasterViewChart * (pinchScale-1) ) , 0 + moveupDown - (yCenterMasterViewChart * (pinchScale-1)), _viewChartsUniversal.frame.size.width , _viewChartsUniversal.frame.size.height);
    
    
    _viewChartsUniversal.frame = CGRectMake(0 + moveLeftRight +leftBorderForChartContainer - (xCenterMasterViewChart * (pinchScale-1) ) , 0 + moveupDown - (yCenterMasterViewChart * (pinchScale-1)), _masterViewCharts.frame.size.width , _masterViewCharts.frame.size.height);
    
}




- (void) loadChartImage {
    
    //NSLog(@"loadChartImage chartImagesDictionary.count %d", chartImagesDictionary.count);

    
    
    if (chartImagesDictionary.count < 1) {
        chartImagesDictionary = [[[NSUserDefaults standardUserDefaults] objectForKey:@"chartImagesDictionary"] mutableCopy];
    }
    
     NSString *imageToLoad = [NSString stringWithFormat:@"image_%@", chartNameToLoad ];
    
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,     NSUserDomainMask, YES);
    NSString *documentsDirectory = [paths objectAtIndex:0];
    
    //NSLog(@"loadChartImage previousChartName %@", previousChartName);
    
    if ([previousChartName isEqualToString:imageToLoad]) {
        //NSLog(@"same image");
        return;
    }else{
       //NSLog(@"new image to load!  -%@-", imageToLoad);
        
         previousChartName = imageToLoad;
        
        //Killer!
        //[_universalChartGraphic setImage: [UIImage imageWithData:[chartImagesDictionary objectForKey: imageToLoad] ]  ];
        [_universalChartGraphic.layer.sublayers makeObjectsPerformSelector:@selector(removeFromSuperlayer)]; // delete old lines        
        for (UIView *subview in _universalChartGraphic.subviews) {
            [subview removeFromSuperview];
        }
        
        //double size to enhance resolution
        _universalChartGraphic.frame = CGRectMake(0, 0, _universalChartGraphic.frame.size.width * 2, _universalChartGraphic.frame.size.height * 2);        
        _universalChartGraphic.image = nil ;
        
        
        
        
        //[_universalChartGraphic setImage: [UIImage imageWithData:[chartImagesDictionary objectForKey: imageToLoad] ]  ];     
        
        NSString *getImagePath = [documentsDirectory stringByAppendingPathComponent:imageToLoad];
                      UIImage *imageLoaded = [UIImage imageWithContentsOfFile:getImagePath];       
                      [_universalChartGraphic setImage: imageLoaded  ];  
        
        
        
        
        CGRect rect = [_universalChartGraphic bounds];
        UIGraphicsBeginImageContext(rect.size);
        CGContextRef context = UIGraphicsGetCurrentContext();
        [_universalChartGraphic.layer renderInContext:context];
        UIImage *img = UIGraphicsGetImageFromCurrentImageContext();
        _universalChartGraphic.image = nil ; 
        UIGraphicsEndImageContext();      
        _universalChartGraphic.image = img;       
        _universalChartGraphic.frame = CGRectMake(0, 0, _universalChartGraphic.frame.size.width / 2, _universalChartGraphic.frame.size.height / 2);
        

    }
   
    
    
    
    
}


- (void) getInfoFileForThisPart {
    
    // get info file for this part
    arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@", chartNameForThisInfoFile, infoPartNumber, @"infoFile" ];
    infoPartArray = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
    if ([[infoPartArray objectAtIndex:10] isEqualToString:@"Y"] || [[infoPartArray objectAtIndex:10] isEqualToString:@"y"] ) { yToX = 1; }else{ yToX = 0; }
    
    
    
    
          
          
    
    //NSLog(@"infoPartArray %@", infoPartArray);
    
    unitResult = [infoPartArray objectAtIndex:14];
    
    // get line base for X and Y (line base is the edge of the chart)
    
    minCurve =   [[infoPartArray objectAtIndex:15] floatValue];
    maxCurve =   [[infoPartArray objectAtIndex:16] floatValue];
    
    minInput =   [[infoPartArray objectAtIndex:17] floatValue];
    maxInput =   [[infoPartArray objectAtIndex:18] floatValue];
    minResult =  [[infoPartArray objectAtIndex:19] floatValue];
    
    
    
    // check if max result contains text "External" or "hoist" etc
    // then take max value from them
    
    NSString *specialMaxResultString = [infoPartArray objectAtIndex:21];
    //NSLog(@"specialMaxResultString %@", specialMaxResultString);
    
    maxResult =  [[infoPartArray objectAtIndex:20] floatValue];
    
    maxResultWithRestriction = maxResult;
    
    if ([specialMaxResultString rangeOfString:@"EX"].location != NSNotFound ) {
        
        specialMaxResultString = [specialMaxResultString substringFromIndex:2];
        float externalLoadLimitation = [specialMaxResultString floatValue];
        
        if (hoistLoadAttached == 1) {
            
            //NSLog(@"found External Load Limitation and hoist load attached so  we limit to%.0f ", externalLoadLimitation);
            maxResultWithRestriction =  externalLoadLimitation;
        }
    }
    
    
    if ([specialMaxResultString rangeOfString:@"MAX"].location != NSNotFound ) {
        
        
        specialMaxResultString = [specialMaxResultString substringFromIndex:3];
        float specialLimitation = [specialMaxResultString floatValue];
        
        maxResultWithRestriction =  specialLimitation;
        
    }
    
    
    
    
    //NSLog(@"maxResult %.0f ", maxResult);
    
    // get additional values
    
    crossLineSequence =  [infoPartArray objectAtIndex:22];
    
    drawToFixedPointX =  [[infoPartArray objectAtIndex:5] floatValue];
    drawToFixedPointY =  [[infoPartArray objectAtIndex:6] floatValue];
    
    
    // check if part is a transfer value
    
    if ( [[infoPartArray objectAtIndex:13] floatValue] != 0) {
        
        factorForResult = [[infoPartArray objectAtIndex:13] floatValue];
    }else{
        
        factorForResult = 1;
        
 
    }
    
    
   
    
    
    if ( [[infoPartArray objectAtIndex:13] isEqualToString:@"TV"]) {
        flagThisPartResultContainsTransferValue = 1;
        //NSLog(@"contains transferVal  chart: %@ part %d  ", chartNameForThisInfoFile, partNumberToCompute);
    }else{
        flagThisPartResultContainsTransferValue = 0;
    }
    
    
    
    
    if ( ![[infoPartArray objectAtIndex:25] isEqualToString:@""]) {
        newWPDdataAvialable = 1;
    }else{
        newWPDdataAvialable = 0;
    }
    
    
    return;
    
    
    
    
    

    
}


- (void) getInputForCurveAndAxis {
    
    //NSLog(@"getInputForCurveAndAxis infoPartArray %@", infoPartArray);
    //NSLog(@"getInputForCurveAndAxis [infoPartArray objectAtIndex:9] %@", [infoPartArray objectAtIndex:9]);
    
  /*
   0	Category
   1	Manufacturer
   2	AC Type
   3	AC Variant
   4	Chart Name
   5	Number of Computation Parts
   6	Current Computation Part
   7	Unit Y
   8	Unit X
   9	Unit Curves
   10	Input Axis  (y To X)
   11	Input Source
   12	Input From Chart
   13	Result
   14	Result Unit
   15	Min Value Curve
   16	Max Value Curve
   17	Min Input
   18	Max Input
   19	Min Result
   20	Max Result
   21	Date
   22	Initials (CrossLineSequence)
   23	chart width pixel
   24	chartt height pixel
   25	xPix1
   26	xPix2
   27	yPix1
   28	yPix2
   29	xPix3
   30	yPix3
   31	xLeftGC
   32	yBottomGC
   33	xRightGC
   34	yTopGC
   */
    
    // curve input
    
    
    if ([[infoPartArray objectAtIndex:9] isEqualToString:@"TV"]) {
        
        // get transfer value
        
        NSString *loadTransferVal = [ [NSString alloc] initWithFormat:@"%@_%@_%@_%@_%@", ACCategory, ACmanufacturer,AC_Type, ACVariant, [infoPartArray objectAtIndex:11] ];
        
        //NSLog(@"loadTransferVal %@", loadTransferVal );
        
        float transferValLoaded  = [[transferValueDictionary objectForKey:loadTransferVal] floatValue];
        //NSLog(@"transferValLoaded %.2f", transferValLoaded );
        
        
        givenCurveInputValue = transferValLoaded;
        
    }
    
    
    
    if ([[infoPartArray objectAtIndex:9] isEqualToString:@"oneLine"]) {
        // curve needs celsius
        givenCurveInputValue = 0;  // curve // OAT = slider 2
        
    }
    
    
    if ([[infoPartArray objectAtIndex:9] isEqualToString:@"C"]) {
        // curve needs celsius
        givenCurveInputValue = OAT;  // curve // OAT = slider 2
        
    }
    
    if ([[infoPartArray objectAtIndex:9] isEqualToString:@"PA"]) {
        // curve needs celsius
        givenCurveInputValue = Hp;  // Pressure Alt
        
    }
    
    
    if ([[infoPartArray objectAtIndex:9] isEqualToString:@"acWeight"]  || [[infoPartArray objectAtIndex:9] isEqualToString:@"kg"]   ) {
        // curve needs AC weight
        givenCurveInputValue = acWeight; // AC weight
        
       
        
        NSString *testString = [infoPartArray objectAtIndex:15];
        
        //NSLog(@"[infoPartArray objectAtIndex:15] %@ ", testString);
        
        //NSLog(@"[infoPartArray objectAtIndex:15] %.0f ", [testString floatValue]);
        
        if ([ testString  rangeOfString:@"<"].location != NSNotFound      ) {
            
            testString  = [ testString stringByReplacingOccurrencesOfString:@"<" withString:@""];
            
            givenCurveInputValue = [testString floatValue];
            
            //NSLog(@"givenCurveInputValue %.0f", givenCurveInputValue);
            
        }
        
    }
    
    
    if( [ [infoPartArray objectAtIndex:9] caseInsensitiveCompare:@"ktsWind"] == NSOrderedSame    ) {
        givenCurveInputValue = headWindKTS; // kts wind speed
        
    }
    
    if( [ [infoPartArray objectAtIndex:9] caseInsensitiveCompare:@"WindKts"] == NSOrderedSame    ) {
        givenCurveInputValue = headWindKTS; // kts wind speed
        
    }
    
    
   
    
    if( [ [infoPartArray objectAtIndex:9] caseInsensitiveCompare:@"indexX"] == NSOrderedSame ) {
        // curve needs X input from first curve
        givenCurveInputValue = cross1ValueX; // X result from previous computation
    }
    
    if( [ [infoPartArray objectAtIndex:9] caseInsensitiveCompare:@"indexX2"] == NSOrderedSame ) {
        // curve needs X input from first curve
        givenCurveInputValue = cross2ValueX; // X result from previous computation
    }
    
    
    if( [ [infoPartArray objectAtIndex:9] caseInsensitiveCompare:@"indexY"] == NSOrderedSame ) {
        // curve needs Y input from first curve
        givenCurveInputValue = cross1ValueY; // Y result from previous computation

    }
    
    
    //NSLog(@"case 0");
    
    if( [ [infoPartArray objectAtIndex:9] caseInsensitiveCompare:@"indexY2"] == NSOrderedSame ) {
        // curve needs Y input from second curve
        givenCurveInputValue = cross2ValueY; // Y result from previous computation
        
    }
      
    
    
    
    //NSLog(@"givenCurveInputValue [infoPartArray objectAtIndex:9] %@   ", [infoPartArray objectAtIndex:9] );
    
    // get input for axis
    // if we go from X to Y, then the unit X is the input data
    // if we go from Y to X, then the unit Y is the input data
    
    //NSLog(@"yToX %d ", yToX);
    
    
     flagOATisXaxis = 0;
    
    if (yToX == 0) {
        // if we go X to Y
        
        //NSLog(@"case 1");
        
        
        //NSLog(@"[infoPartArray objectAtIndex:8] %@", [infoPartArray objectAtIndex:8]);
        
        if ([ [infoPartArray objectAtIndex:8]  rangeOfString:@"fix"].location != NSNotFound      ) {
            
            NSString *subString =  [infoPartArray objectAtIndex:8];
            subString = [subString substringFromIndex:3];
            float subStringValue = [subString floatValue];
            givenAxisInputValue = subStringValue; // input is a fixed value (see BAZL Velocity part 4
            
            
            
        }
        
        
       
        
        
        if( [ [infoPartArray objectAtIndex:8] caseInsensitiveCompare:@"acWeight"] == NSOrderedSame ) {
            // axis needs AC weight
            givenAxisInputValue = acWeight; // AC weight
            
           

            
        }

        
        
       
        
        if( [ [infoPartArray objectAtIndex:8] caseInsensitiveCompare:@"ktsWind"] == NSOrderedSame ) {
            givenAxisInputValue = headWindKTS; // kts wind speed
            
        }
        
        if( [ [infoPartArray objectAtIndex:8] caseInsensitiveCompare:@"WindKts"] == NSOrderedSame ) {
            givenAxisInputValue = headWindKTS; // kts wind speed
            
        }

        
        
        
        if ([[infoPartArray objectAtIndex:8] isEqualToString:@"PA"]) {
            // inout is PA
            givenAxisInputValue = Hp; // PA
        }
        
        
        if ([[infoPartArray objectAtIndex:8] isEqualToString:@"C"] || [[infoPartArray objectAtIndex:8] isEqualToString:@"OAT"] ) {
            // inout is OAT
            givenAxisInputValue = OAT;  // curve // OAT
            
            flagOATisXaxis = 1;
             //NSLog(@"3 yToX %d ", yToX);
        }
        
        
       
        
        
        if ([ [infoPartArray objectAtIndex:8] caseInsensitiveCompare:@"indexX"] == NSOrderedSame ) {
            // inout is PA
            givenAxisInputValue = resultComputation;  // result from previous chart

        }
        
        
        
        
        
        
    }else{
        
        
        //NSLog(@"case 2");
        
        //NSLog(@"[infoPartArray objectAtIndex:7] %@", [infoPartArray objectAtIndex:7]);
        
        // if we go Y to X
        
       
        if ([[infoPartArray objectAtIndex:7] isEqualToString:@"TV"]) {
            
            // get transfer value
            
            NSString *loadTransferVal = [ [NSString alloc] initWithFormat:@"%@_%@_%@_%@_%@", ACCategory, ACmanufacturer,AC_Type, ACVariant, [infoPartArray objectAtIndex:11] ];
            
            //NSLog(@"loadTransferVal %@", loadTransferVal );
            
            float transferValLoaded  = [[transferValueDictionary objectForKey:loadTransferVal] floatValue];
            //NSLog(@"transferValLoaded %.2f", transferValLoaded );
            
            
            givenAxisInputValue = transferValLoaded;
            
        }
        
        
        
        
        if ([[infoPartArray objectAtIndex:7] isEqualToString:@"acWeight"]  || [[infoPartArray objectAtIndex:7] isEqualToString:@"kg"]   ) {
            // axis needs AC weight
            givenAxisInputValue = acWeight; // AC weight
            
            
            
            //NSLog(@"[************* Yes, we need AC weight");
        }
        
        
        if ([[infoPartArray objectAtIndex:7] isEqualToString:@"acWgtPenalty"]    ) {
            // axis needs AC weight
            givenAxisInputValue = unchangedACWeight; // AC weight
            //NSLog(@"acWgtPenalty ************* using penalty for chart %@", [infoPartArray objectAtIndex:4] );
            //NSLog(@"acWeight %.0f", acWeight );
            //NSLog(@"givenAxisInputValue %.0f", givenAxisInputValue );
        }
        

        
        
        
        
       
        
        if( [ [infoPartArray objectAtIndex:7] caseInsensitiveCompare:@"index"] == NSOrderedSame ) {
            givenAxisInputValue = resultComputation; // result from previous chart
        }

        
        
        
        if( [ [infoPartArray objectAtIndex:7] caseInsensitiveCompare:@"indexY"] == NSOrderedSame ) {
             givenAxisInputValue = resultComputation; // result from previous chart
        }
        
       
        
        
        
        if ([[infoPartArray objectAtIndex:7] isEqualToString:@"ktsWind"]) {
            
            givenAxisInputValue = headWindKTS; // kts wind speed
            
            //NSLog(@"givenAxisInputValue = _slider4.value;; // kts wind speed ");
        }
        
        if ([[infoPartArray objectAtIndex:7] isEqualToString:@"WindKts"]) {
            
            givenAxisInputValue = headWindKTS; // kts wind speed
            
            //NSLog(@"givenAxisInputValue = _slider4.value;; // kts wind speed ");
        }
        
        
        
        
        
        if ([[infoPartArray objectAtIndex:7] isEqualToString:@"PA"]) {
            
            givenAxisInputValue = Hp; // PA = slider 1
        }
        
        
        if ([[infoPartArray objectAtIndex:7] isEqualToString:@"C"]  || [[infoPartArray objectAtIndex:7] isEqualToString:@"OAT"] ) {
            // inout is OAT
            givenAxisInputValue = OAT;  // curve // OAT
            
            }
        
        
        
        
    }
    
    
    //NSLog(@"givenAxisInputValue = %f ", givenAxisInputValue );
    
    //NSLog(@"givenCurveInputValue = %f ", givenCurveInputValue );
    
    //NSLog(@"acWeight was = %f ", acWeight );
    
    return;
    
    
    
    
    
    
    
    
}

- (void) checkInputDataRange {
    
   
    
    //NSLog(@"givenCurveInputValue  %.0f" , givenCurveInputValue);
    //NSLog(@"minCurve  %.0f" , minCurve);
    //NSLog(@"maxCurve  %.0f" , maxCurve);
    
    flagInputDataOutOfRange = 0;
    
    
    if (givenCurveInputValue < minCurve) {
        givenCurveInputValue = minCurve; flagInputDataOutOfRange = 1;
    }
    
    if (givenCurveInputValue > maxCurve) {
        givenCurveInputValue = maxCurve; flagInputDataOutOfRange = 2;
    }
    
    
    if (givenAxisInputValue < minInput) {
        givenAxisInputValue = minInput; flagInputDataOutOfRange = 3;
    }
    
    if (givenAxisInputValue > maxInput) {
        givenAxisInputValue = maxInput; flagInputDataOutOfRange = 4;
    }
    
    if (flagInputDataOutOfRange > 0) {
        //NSLog(@"flagInputDataOutOfRange %@ %d ", chartNameForThisInfoFile, flagInputDataOutOfRange);
    }
    
    return;
    
    
}

- (void) calcComputation {
    
    
   
    
    
    arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@", chartNameForThisInfoFile, partNumberToCompute, @"curves" ];
    availableCurvesArray = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
    
   
    
    //NSLog(@"availableCurvesArray %@ ", availableCurvesArray);

    
    int foundAvailableCurve = 0, availableCurve = 0, availableAxis = 0; float resultY1 = 0, resultY2 = 0, curveVal1 = 0, curveVal2 = 0;;
    resultComputation = 0;
    
    
    // begin search for given value in curve array (i.e. is -25 in array -40, -30, -20, 10 ...
    for(availableCurve=0; availableCurve<availableCurvesArray.count-1; availableCurve++) {
        // check if given value is in between array values
        
        //NSLog(@"givenCurveInputValue %.0f ", givenCurveInputValue);
        
        //NSLog(@"givenAxisInputValue %.0f ", givenAxisInputValue);
        
        //NSLog(@"[availableCurvesArray objectAtIndex:availableCurve] floatValue] %.0f ", [[availableCurvesArray objectAtIndex:availableCurve] floatValue]);
        //NSLog(@"[availableCurvesArray objectAtIndex:availableCurve+1] floatValue] %.0f ", [[availableCurvesArray objectAtIndex:availableCurve+1] floatValue]);
        
        
        if (givenCurveInputValue >=  [[availableCurvesArray objectAtIndex:availableCurve] floatValue] &  givenCurveInputValue <=  [[availableCurvesArray objectAtIndex:availableCurve+1] floatValue]   ) {
            foundAvailableCurve = 1; break;
        }else if (givenCurveInputValue <=  [[availableCurvesArray objectAtIndex:availableCurve] floatValue] &  givenCurveInputValue >=  [[availableCurvesArray objectAtIndex:availableCurve+1] floatValue] ){
            foundAvailableCurve = 1; break;
        }
    }
    if (foundAvailableCurve == 1) {
        
        //NSLog(@"foundAvailableCurve  1");
        
        curveVal1 = [[availableCurvesArray objectAtIndex:availableCurve] floatValue];
        curveVal2 = [[availableCurvesArray objectAtIndex:availableCurve+1] floatValue];
        
        /*
         if (nChart == 2 & partNumberToCompute == 1) {
         //NSLog(@"OK found availableCurve between %.1f and %.1f ", curveVal1, curveVal2 );
         //NSLog(@"OK curve index found between %d and %d ", availableCurve+1, availableCurve+2 );
         }
         */
        
        //NSLog(@"OK found availableCurve between %.1f and %.1f ", curveVal1, curveVal2 );

        
        //NSLog(@"OK found availableCurve between %.1f and %.1f ", curveVal1, curveVal2 );
        //NSLog(@"OK curve index found between %d and %d ", availableCurve+1, availableCurve+2 );
        
    }else{
        
        //NSLog(@"foundAvailableCurve  0");
        
        //NSLog(@"1 !!!! %@  part %d  no available curve", chartNameForThisInfoFile, partNumberToCompute);
        
        /*
         if (nChart == 2 & partNumberToCompute == 1) {
         //NSLog(@"1 !!!! %@  part %d  no available curve", chartNameForThisInfoFile, partNumberToCompute);        }
         */
        
        return;
        
    }
    
    
    // ****************************************************************************************************************************
    // X ans Y axis from first set
    
    
    NSArray* curveValuesX1;
    NSArray* curveValuesY1;
    
    //NSLog(@"yToX %d", yToX);
    
    if (yToX == 0) {
        
        arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@_%@",  chartNameForThisInfoFile, partNumberToCompute, [availableCurvesArray objectAtIndex:availableCurve], @"xAxis" ];
        curveValuesX1 = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
        
        //NSLog(@"arrayKey %@ ", arrayKey );
        //NSLog(@"curveValuesX1 %@ ", curveValuesX1 );
        
        arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@_%@", chartNameForThisInfoFile, partNumberToCompute, [availableCurvesArray objectAtIndex:availableCurve], @"yAxis" ];
        curveValuesY1 = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
        //NSLog(@"curveValuesY1 %@ ", curveValuesY1 );
        
        
    }else{
        // reverse axis
        arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@_%@",  chartNameForThisInfoFile, partNumberToCompute, [availableCurvesArray objectAtIndex:availableCurve], @"yAxis" ];
        //NSLog(@"reversed arrayKey x %@ ", arrayKey );
        
        curveValuesX1 = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
        //NSLog(@"reversed curveValuesX1 %@ ", curveValuesX1 );
        
        arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@_%@",  chartNameForThisInfoFile, partNumberToCompute, [availableCurvesArray objectAtIndex:availableCurve], @"xAxis" ];
        //NSLog(@"reversed arrayKey y %@ ", arrayKey );
        curveValuesY1 = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
        //NSLog(@"reversed curveValuesY1 %@ ", curveValuesY1 );
    }
    
    
    
    
    /*
     if (nChart == 2 & partNumberToCompute == 1) {
     
     //NSLog(@" curveValuesX1 %@ ", curveValuesX1 );
     //NSLog(@" curveValuesY1 %@ ", curveValuesY1 );
     }
     */
    
    foundAvailableCurve = 0;
    float foundavailableAxis = 0;
    
    for(availableAxis=0; availableAxis<curveValuesX1.count; availableAxis++) {
        
        // check if given value is in between array values
        
        /*
         if (nChart == 2 & partNumberToCompute == 1) {
         
         //NSLog(@"givenAxisInputValue %.0f ", givenAxisInputValue);
         
         //NSLog(@"[[curveValuesX1 objectAtIndex:availableAxis] floatValue] %.0f ", [[curveValuesX1 objectAtIndex:availableAxis] floatValue]);
         
         //NSLog(@"[[curveValuesX1 objectAtIndex:availableAxis] floatValue+1] %.0f ", [[curveValuesX1 objectAtIndex:availableAxis+1] floatValue]);
         
         }
         */
        
        
        
        
        
        if (givenAxisInputValue >=  [[curveValuesX1 objectAtIndex:availableAxis] floatValue] &  givenAxisInputValue <=  [[curveValuesX1 objectAtIndex:availableAxis+1] floatValue]   ) {
            foundavailableAxis = 1; break;
        }else if (givenAxisInputValue <=  [[curveValuesX1 objectAtIndex:availableAxis] floatValue] &  givenAxisInputValue >=  [[curveValuesX1 objectAtIndex:availableAxis+1] floatValue] ){
            foundavailableAxis = 1; break;
        }
    }
    
    
    if (foundavailableAxis == 1) {
        
        //NSLog(@"foundavailableAxis  1");
        
        float x1 = [[curveValuesX1 objectAtIndex:availableAxis] floatValue];
        float x2 = [[curveValuesX1 objectAtIndex:availableAxis+1] floatValue];
        
        float y1 = [[curveValuesY1 objectAtIndex:availableAxis] floatValue];
        float y2 = [[curveValuesY1 objectAtIndex:availableAxis+1] floatValue];
        
        resultY1 = y1  + ( (y2-y1) / (x2-x1) * (givenAxisInputValue - x1));
        
        /*
         if (nChart == 2 & partNumberToCompute == 1) {
         
         //NSLog(@"resultY1 %.2f ", resultY1);
         //NSLog(@"Y axis data x %.3f y %.3f ", y1, y2 ) ;
         }
         */
        
        
        
        
    }else{
        
        //NSLog(@"foundavailableAxis  0");
        
        //NSLog(@"2 !!!! %@  part %d  no available axis data", chartNameForThisInfoFile, partNumberToCompute);
        
        //NSLog(@"givenCurveInputValue %.0f ", givenCurveInputValue);
        
        //NSLog(@"givenAxisInputValue %.0f ", givenAxisInputValue);
        
        
        return;
    }
    
    
    // ****************************************************************************************************************************
    // X ans Y axis from second set
    
    NSArray* curveValuesX2;
    NSArray* curveValuesY2;
    
    if (yToX == 0) {
        
        arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@_%@", chartNameForThisInfoFile, partNumberToCompute, [availableCurvesArray objectAtIndex:availableCurve+1], @"xAxis" ];
        curveValuesX2 = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
        //NSLog(@"curveValuesX2 %@ ", curveValuesX2 );
        
        arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@_%@",  chartNameForThisInfoFile, partNumberToCompute, [availableCurvesArray objectAtIndex:availableCurve+1], @"yAxis" ];
        curveValuesY2 = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
        //NSLog(@"curveValuesY2 %@ ", curveValuesY2 );
        
        
    }else{
        // reverse axis
        
        arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@_%@",  chartNameForThisInfoFile, partNumberToCompute, [availableCurvesArray objectAtIndex:availableCurve+1], @"yAxis" ];
        curveValuesX2 = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
        //NSLog(@"reversed arrayKey %@ ", arrayKey );
        //NSLog(@"reversed curveValuesX2 %@ ", curveValuesX2 );
        
        arrayKey = [ [NSString alloc] initWithFormat:@"%@_part%d_%@_%@", chartNameForThisInfoFile, partNumberToCompute, [availableCurvesArray objectAtIndex:availableCurve+1], @"xAxis" ];
        curveValuesY2 = [[[NSUserDefaults standardUserDefaults] objectForKey:arrayKey] mutableCopy];
        //NSLog(@"reversed arrayKey %@ ", arrayKey );
        //NSLog(@"reversed curveValuesY2 %@ ", curveValuesY2 );
        
        
        
    }
    
    /*
     
     if (nChart == 2 & partNumberToCompute == 1) {
     
     //NSLog(@"curveValuesX2 %@ ", curveValuesX2 );
     //NSLog(@"curveValuesY2 %@ ", curveValuesY2 );
     }
     */
    
    
    
    foundAvailableCurve = 0;
    foundavailableAxis = 0;
    
    //NSLog(@"[curveValuesX2 %@", curveValuesX2);
    
    
    for(availableAxis=0; availableAxis<curveValuesX2.count; availableAxis++) {
        
        //NSLog(@"[givenAxisInputValue %f " , givenAxisInputValue);
        
        //NSLog(@"[curveValuesX2 objectAtIndex:availableAxis] floatValue]  %f ", [[curveValuesX2 objectAtIndex:availableAxis] floatValue] );
        
        //NSLog(@"[[curveValuesX2 objectAtIndex:availableAxis+1] floatValue]   %f ",[[curveValuesX2 objectAtIndex:availableAxis+1] floatValue]  );
        
        
        // check if given value is in between array values
        if (givenAxisInputValue >=  [[curveValuesX2 objectAtIndex:availableAxis] floatValue] &  givenAxisInputValue <=  [[curveValuesX2 objectAtIndex:availableAxis+1] floatValue]   ) {
            foundavailableAxis = 1;
            //NSLog(@"> < foundavailableAxis ");
            break;
        }else if (givenAxisInputValue <=  [[curveValuesX2 objectAtIndex:availableAxis] floatValue] &  givenAxisInputValue >=  [[curveValuesX2 objectAtIndex:availableAxis+1] floatValue] ){
            foundavailableAxis = 1;
            //NSLog(@"< > foundavailableAxis ");
            break;
        }
    }
    
    
    if (foundavailableAxis == 1) {
        
        float x1 = [[curveValuesX2 objectAtIndex:availableAxis] floatValue];
        float x2 = [[curveValuesX2 objectAtIndex:availableAxis+1] floatValue];
        
        float y1 = [[curveValuesY2 objectAtIndex:availableAxis] floatValue];
        float y2 = [[curveValuesY2 objectAtIndex:availableAxis+1] floatValue];
        
        //NSLog(@"X axis data x %.3f y %.3f ", x1, x2 );
        resultY2 = y1  + ( (y2-y1) / (x2-x1) * (givenAxisInputValue - x1));
        //NSLog(@"resultY2 %.2f ", resultY2);
        
        /*
         if (nChart == 2 & partNumberToCompute == 1) {
         
         //NSLog(@"X axis data x %.3f y %.3f ", x1, x2 );
         //NSLog(@"resultY2 %.2f ", resultY2);
         }
         */
        
        
        
    }else{
        
        
        //NSLog(@"curveValuesX2 %@", curveV"exaluesX2);
        
        
        //NSLog(@"3 !!!! %@  part %d  no available axis data", chartNameForThisInfoFile, partNumberToCompute);
        
        return;
    }
    
    
    
    
    
    // interpolate for curve
    resultComputation = resultY1  + ( (resultY2-resultY1) / (curveVal2 - curveVal1) * (givenCurveInputValue - curveVal1));
    
    //NSLog(@"givenCurveInputValue %.3f ", givenCurveInputValue);
    
    //NSLog(@"resultY2 %.3f ", resultY2);
    //NSLog(@"resultY1 %.3f ", resultY1);
    
    //NSLog(@"curveVal2 %.3f ", curveVal2);
    //NSLog(@"curveVal1 %.3f ", curveVal1);
    
    
    
    //NSLog(@"resultComputation %.3f ", resultComputation);
    
    
    
    
    
}

- (void) limitResultValues {
    
    
    // limit the result values
    
    flagOutputDataOutOfRange = 0;
    
    
    if (resultComputation < minResult) {
        resultComputation = minResult; flagOutputDataOutOfRange = 1;
    }
    
    if (resultComputation > maxResultWithRestriction) {
        resultComputation = maxResultWithRestriction; flagOutputDataOutOfRange = 2;
    }
    
    if (flagOutputDataOutOfRange > 0) {
        //NSLog(@"flagOutputDataOutOfRange %@ %d ", chartNameForThisInfoFile, flagOutputDataOutOfRange);
    }
    
    
    
    if (partNumberToCompute == 1) {
        if (yToX == 0) { // wenn X to Y, then cross1ValueY = resultComputation;
            cross1ValueX = givenAxisInputValue;
            cross1ValueY = resultComputation;
        }else{
            cross1ValueX = resultComputation;
            cross1ValueY = givenAxisInputValue;
        }
        
        
    }
    
    
    if (partNumberToCompute == 2) {
        if (yToX == 0) { // wenn X to Y, then cross1ValueY = resultComputation;
            cross2ValueX = givenAxisInputValue;
            cross2ValueY = resultComputation;
        }else{
            cross2ValueX = resultComputation;
            cross2ValueY = givenAxisInputValue;
        }
        
    }
    
    if (partNumberToCompute == 3) {
        if (yToX == 0) { // wenn X to Y, then cross1ValueY = resultComputation;
            cross3ValueX = givenAxisInputValue;
            cross3ValueY = resultComputation;
        }else{
            cross3ValueX = resultComputation;
            cross3ValueY = givenAxisInputValue;
        }
        
    }
    
    
    if (partNumberToCompute == 4) {
        if (yToX == 0) { // wenn X to Y, then cross1ValueY = resultComputation;
            cross4ValueX = givenAxisInputValue;
            cross4ValueY = resultComputation;
        }else{
            cross4ValueX = resultComputation;
            cross4ValueY = givenAxisInputValue;
        }
        
    }
    
    
    return;
    
    
    
}

// perf chart zoom

- (void)twoFingerPinch:(UIPinchGestureRecognizer *)recognizer {
    
    if (_viewCATAOverview1.hidden == NO || _viewCATAOverview2.hidden == NO || _viewCATAOverview3.hidden == NO || _viewMixedCG.hidden == NO || _viewDriftDown.hidden == NO) {
        return;
    }
    
    
    pinchScale =  ((recognizer.scale-1) * 2) + pinchScaleEnded;
    
     //NSLog(@"twoFingerPinch pinchScale %.0f", pinchScale);
    
    if (pinchScale <= 1.1) {
        
        // reset view
        
        pinchScale= 1.0;
        moveupDown = 0; moveLeftRight = 0;
        
        CGAffineTransform transform = CGAffineTransformMakeScale(1, 1);
        self.viewChartsUniversal.transform = transform;
        
        [self computeChartSizeInApp];
        
    }else{
        
        if (pinchScale > 3.0) {
            pinchScale = 3.0;
        }
        
        CGAffineTransform transform = CGAffineTransformMakeScale(pinchScale, pinchScale);
        self.viewChartsUniversal.transform = transform;
        
        [self computeChartSizeInApp];
        
    }
    
    
    if(recognizer.state == UIGestureRecognizerStateEnded)
    {
        pinchScaleEnded = pinchScale;
        
    }
    
    
}

- (void)panRecognizer:(UIPanGestureRecognizer *)recognizer {
    
    
    if (_viewCATAOverview1.hidden == NO || _viewCATAOverview2.hidden == NO || _viewCATAOverview3.hidden == NO || _viewMixedCG.hidden == NO  || _viewDriftDown.hidden == NO) {
        return;
    }
    
    CGPoint translation = [recognizer translationInView:self.view];
    
    moveupDown =  moveupDown + (translation.y / 1);
    
    moveLeftRight = moveLeftRight + (translation.x / 1);
    
    //NSLog(@"panRecognizer moveupDown %.0f", moveupDown);
    
    
    [self computeChartSizeInApp];
    
    [recognizer setTranslation:CGPointMake(0, 0) inView:self.view];
    
    
}


- (void)handleSingleTapOnView:(UIPanGestureRecognizer *)recognizer {
    
    
    if (_viewCATAOverview1.hidden == NO || _viewCATAOverview2.hidden == NO || _viewCATAOverview3.hidden == NO || _viewMixedCG.hidden == NO || _viewDriftDown.hidden == NO) {
        return;
    }
    
    
    //NSLog(@"handleSingleTapOnView");
    
    moveLeftRight = 0; moveupDown = 0;
    
    
    if (fullScreenPerfCharts == 0) {
        fullScreenPerfCharts = 1;
    }else{
        
        fullScreenPerfCharts = 0;
    }
    
    
    ViewController *parent = (ViewController *)self.parentViewController;
    [parent actionFullScreenPerfChart: fullScreenPerfCharts];
    
    
    
    [self calcPerformance];
    
   
    
    
}

- (void) interpolationMethod: (float)receivedBaseValue lowVal:(float)receivedLowVal highVal:(float)receivedHighVal lowSearch:(float)receivedLowSearch highSearch:(float)receivedHighSearch {

     interpolationResult = receivedLowSearch + ((receivedHighSearch - receivedLowSearch) * (((receivedBaseValue - receivedLowVal) * (100 / (receivedHighVal - receivedLowVal))) / 100 )) ;
    
    
    //float interpolationResult = 100 + ((receivedValHigh - receivedValLow) * (((receivedCriteria1 - receivedVal2Low) * (100 / (receivedVal2High - receivedVal2Low))) / 100 )) ;
    
    //NSLog(@"interpolatedRC1eng %.0f", interpolationResult);
    
 
    
}



- (IBAction)actionSwitchCATAVTOL:(id)sender {
    
    if (_viewVTOL.hidden == YES) {
        _viewVTOL.hidden = NO;
        _viewCATACH.hidden = YES;
    }else{
        _viewVTOL.hidden = YES;
        _viewCATACH.hidden = NO;
    }
    
}

- (void) resetInputObstacleHeight {
    
    
    _inputObstacleHeightMeter.text = @"0";
    _sliderObstHeight.value = 0;
}


- (IBAction)closeKeyboard:(id)sender {
    
    _sliderObstHeight.value = [_inputObstacleHeightMeter.text floatValue];
    
    [self.view endEditing:TRUE];
    
    [self calcModifiedTOPath];

    
}

- (void) calcModifiedTOPath {
    
    
    obstHeightExtern = _sliderObstHeight.value;
    
    
    
    TDPheight = 0;
    RearwardTODist = 0;
    MinHeight = 0;
    HeightAchievedVTOSS = 0;
    contTODist = 0;
    
    MinHeight =  35 + ([_inputObstacleHeightMeter.text floatValue] * 3.28084 );
                         
                         
    
    if (MinHeight >=35 & MinHeight < 45) {  TDPheight = 130; RearwardTODist = 50; HeightAchievedVTOSS = 40; contTODist = 190; }
    if (MinHeight >=45 & MinHeight < 55) {  TDPheight = 140; RearwardTODist = 54; HeightAchievedVTOSS = 50; contTODist = 186; }
    if (MinHeight >=55 & MinHeight < 65) {  TDPheight = 150; RearwardTODist = 58; HeightAchievedVTOSS = 60; contTODist = 182; }
    if (MinHeight >=65 & MinHeight < 75) {  TDPheight = 160; RearwardTODist = 62; HeightAchievedVTOSS = 70; contTODist = 178; }
    if (MinHeight >=75 & MinHeight < 85) {  TDPheight = 170; RearwardTODist = 66; HeightAchievedVTOSS = 80; contTODist = 174; }
    if (MinHeight >=85 & MinHeight < 95) {  TDPheight = 180; RearwardTODist = 70; HeightAchievedVTOSS = 90; contTODist = 170; }
    if (MinHeight >=95 & MinHeight < 105) {  TDPheight = 190; RearwardTODist = 74; HeightAchievedVTOSS = 100; contTODist = 166; }
    if (MinHeight >=105 & MinHeight < 115) {  TDPheight = 200; RearwardTODist = 78; HeightAchievedVTOSS = 110; contTODist = 162; }
    if (MinHeight >=115 & MinHeight < 120) {  TDPheight = 210; RearwardTODist = 82; HeightAchievedVTOSS = 120; contTODist = 158; }
    
    
    _labelMinHeight.text = [[NSString alloc] initWithFormat:@"%.0f ft", MinHeight ];
    
    _labelTDPHeight.text = [[NSString alloc] initWithFormat:@"%.0f ft", TDPheight ];
    
    _labelRearwardTODist.text = [[NSString alloc] initWithFormat:@"%.0f m", RearwardTODist ];
    
    _labelHeightAchieved.text = [[NSString alloc] initWithFormat:@"%.0f ft", HeightAchievedVTOSS ];
    
    _labelContinuedTODist.text = [[NSString alloc] initWithFormat:@"%.0f m", contTODist ];
    
    
    
    
    
    
}
- (IBAction)sliderActionObstHeight:(id)sender {
    
    int dummy = _sliderObstHeight.value/5;
    _sliderObstHeight.value = dummy * 5;
    
    _inputObstacleHeightMeter.text = [[NSString alloc] initWithFormat:@"%.0f", _sliderObstHeight.value ];
    
    
    [self calcModifiedTOPath];

    
}


- (void) calcDriftDown{ 
    
    //NSLog(@"calcDriftDown");
    
       float MEA1elevation = [_inputMEA1elevation.text floatValue];
    
       float geschaetzteUeberhoehung = _sliderGeschUeber.value;
    
      _lSliderGeschUeberhoehung.text = [[NSString alloc] initWithFormat:@"%.0f ft", geschaetzteUeberhoehung ];
   
      _lResultOEIMCPCeiling.text = [[NSString alloc] initWithFormat:@"%.0f ft/min",resultOEIMCPCeiling];
      
      _lMEA1diffToSC.text  = [[NSString alloc] initWithFormat:@"%.0f ft", MEA1elevation -  resultOEIMCPCeiling];
      
      float ueberhoehungTotal =   geschaetzteUeberhoehung + [_lMEA1diffToSC.text floatValue];    
      _lUeberhoehungTotal.text  = [[NSString alloc] initWithFormat:@"%.0f ft", ueberhoehungTotal];
      
      float MEA1plusGeschUeberhoehung = geschaetzteUeberhoehung + MEA1elevation;    
      _lMEA1plusGeschUeberhoehung.text  = [[NSString alloc] initWithFormat:@"%.0f ft", MEA1plusGeschUeberhoehung];
    
      _lhoehenverlusst.text  = [[NSString alloc] initWithFormat:@"%.0f ft/NM", resultHoehenverlusst * -1];
    
       float hoehenverlusstTotal = resultHoehenverlusst * -1 * [_inputMEA1distance.text floatValue];
      _lhoehenverlusstTotal.text  = [[NSString alloc] initWithFormat:@"%.0f ft",hoehenverlusstTotal ];
    
  
      float dummy = hoehenverlusstTotal;
      float dummyRoundedThousand = ceil(dummy/100);
    
      float hoehenverlusstTotalRounded = dummyRoundedThousand * 100;    
      _lUeberhoehungFuerGanzesLeg.text = [[NSString alloc] initWithFormat:@"%.0f ft", hoehenverlusstTotalRounded ];

    
      
      float driftDownMinElev = MEA1plusGeschUeberhoehung - hoehenverlusstTotalRounded;
      _lDriftDownMinElevation.text = [[NSString alloc] initWithFormat:@"%.0f ft", driftDownMinElev ];
    
    if (driftDownMinElev > MEA1elevation) {
        _lResultCheck.text = [[NSString alloc] initWithFormat:@"%.0f ft OK", MEA1plusGeschUeberhoehung ]; 
        _lResultCheck.textColor = GreenColor;
    }else{
        
        _lResultCheck.text = @"Überhöhung zu niedrig";
        _lResultCheck.textColor = [UIColor redColor];
    }
    
       //sdf
    
    // MEA 2
    
     float MEA2elevation = [_inputMEA2elevation.text floatValue];
     float geschaetzteUeberhoehungMEA2 = _sliderGeschUeber.value;
    
     //_lSliderGeschUeberhoehungMEA2.text = [[NSString alloc] initWithFormat:@"%.0f ft", geschaetzteUeberhoehungMEA2 ];
    
     _lMEA2diffToSC.text  = [[NSString alloc] initWithFormat:@"%.0f ft", MEA2elevation -  resultOEIMCPCeiling];
    
      float ueberhoehungTotalMEA2 =   geschaetzteUeberhoehungMEA2 + [_lMEA2diffToSC.text floatValue];
     _lUeberhoehungTotalMEA2.text  = [[NSString alloc] initWithFormat:@"%.0f ft", ueberhoehungTotalMEA2];
    
     float MEA2plusGeschUeberhoehung = geschaetzteUeberhoehungMEA2 + MEA2elevation; 
     _lMEA2plusGeschUeberhoehung.text  = [[NSString alloc] initWithFormat:@"%.0f ft", MEA2plusGeschUeberhoehung];
    
    _lhoehenverlusstMEA2.text  = [[NSString alloc] initWithFormat:@"%.0f ft/NM", resultHoehenverlusstMEA2 * -1];
    
    float hoehenverlusstTotalMEA2 = resultHoehenverlusstMEA2 * -1 * [_inputMEA2distance.text floatValue];
    _lhoehenverlusstTotalMEA2.text  = [[NSString alloc] initWithFormat:@"%.0f ft",hoehenverlusstTotalMEA2 ];
    
    float dummyMEA2 = hoehenverlusstTotalMEA2;
    float dummyRoundedThousandMEA2 = ceil(dummyMEA2/100);
    
    float hoehenverlusstTotalRoundedMEA2 = dummyRoundedThousandMEA2 * 100;    
    _lUeberhoehungFuerGanzesLegMEA2.text = [[NSString alloc] initWithFormat:@"%.0f ft", hoehenverlusstTotalRoundedMEA2 ];
    
    
    
    float driftDownMinElevMEA2 = MEA2plusGeschUeberhoehung - hoehenverlusstTotalRoundedMEA2;
    _lDriftDownMinElevationMEA2.text = [[NSString alloc] initWithFormat:@"%.0f ft", driftDownMinElevMEA2 ];
    
    if (driftDownMinElevMEA2 > MEA2elevation) {
        _lResultCheckMEA2.text = [[NSString alloc] initWithFormat:@"%.0f ft OK", MEA2plusGeschUeberhoehung ]; 
        _lResultCheckMEA2.textColor = GreenColor;
    }else{
        
        _lResultCheckMEA2.text = @"Überhöhung zu niedrig";
        _lResultCheckMEA2.textColor = [UIColor redColor];
    }
    
    
}


- (void) calcMixedCG {    
   
    _lSidMapTop.text = [[NSString alloc] initWithFormat:@"%.0f", Hp ];
    _labelDifferenceAirportElevToSid.text = [[NSString alloc] initWithFormat:@"%.0f", Hp - [_mcgInputAirportElevationMSL.text floatValue] ];
    
    float lVyinFtMin =  [_lVy.text floatValue] * 6076.12 / 60;
    _lVyinFtMin.text = [[NSString alloc] initWithFormat:@"%.0f",lVyinFtMin];
    
    _lCG2min.text = [[NSString alloc] initWithFormat:@"%.2f", resultCG2minPercent ];
    
    float lClimbRate2min = lVyinFtMin * [_lCG2min.text floatValue] / 100;
    _lClimbRate2min.text = [[NSString alloc] initWithFormat:@"%.0f", lClimbRate2min ];
    
    _labelTime2Min.text = [[NSString alloc] initWithFormat:@"%.2f", 2.0 ]; // time is fix 2 min
    
    float lTotalClimb2Min = lClimbRate2min * 2.0 ;
    _lTotalClimb2Min.text = [[NSString alloc] initWithFormat:@"%.0f", lTotalClimb2Min ]; 
    
    //mcp
    
    _lCGMCP.text = [[NSString alloc] initWithFormat:@"%.2f", resultCGMCPPercent ];
    
    float lClimbRateMCP = [_lCGMCP.text floatValue] * lVyinFtMin / 100;
    _lClimbRateMCP.text = [[NSString alloc] initWithFormat:@"%.0f", lClimbRateMCP ];
    
    float lTimeMCP =  ([_labelDifferenceAirportElevToSid.text floatValue] - lTotalClimb2Min) / lClimbRateMCP ;
    //_lTimeMCP.text = [[NSString alloc] initWithFormat:@"%.2f", lTimeMCP];
    
     //NSLog(@"1 lTimeMCP %f ", lTimeMCP);
    
    
    NSString *minusSignTime = @" ";
    float timeInSecond = lTimeMCP * 60;
    int triggerNegativeTime = 0;
    if (timeInSecond < 0.0) {
        triggerNegativeTime = 1;
    }
    
  
    
    if (timeInSecond < 0.0) {
        timeInSecond = timeInSecond * -1.0;
        minusSignTime = @"-";
    }
    int time = (int)timeInSecond;    
    int seconds = time % 60;
    int minutes = (time / 60) % 60;
    if (seconds < 10) {
        _lTimeMCP.text = [NSString stringWithFormat:@"%@%d:0%d", minusSignTime, minutes, seconds];
    }else{
        _lTimeMCP.text = [NSString stringWithFormat:@"%@%d:%d", minusSignTime, minutes, seconds];
    }
 
    
 
    
   if (triggerNegativeTime == 1) {
       _lTimeMCP.text = @"0:00";      
 
   }
    
    
    
    float lTotalClimbMCP =  lTimeMCP * lClimbRateMCP ;
    _lTotalClimbMCP.text = [[NSString alloc] initWithFormat:@"%.0f", lTotalClimbMCP];
    if (lTotalClimbMCP < 0) {
        _lTotalClimbMCP.text = @"0";
    }
    
    
    
    float lTotalTime = 2.0 + lTimeMCP;
    //_lTotalTime.text = [[NSString alloc] initWithFormat:@"%.1f", lTotalTime ];
    
    minusSignTime = @" ";
    timeInSecond = lTotalTime * 60;
    triggerNegativeTime = 0;
    if (timeInSecond < 0.0) {
        triggerNegativeTime = 1;
    }
    
    if (timeInSecond < 0.0) {
        timeInSecond = timeInSecond * -1.0;
        minusSignTime = @"-";
    }
    time = (int)timeInSecond;    
    seconds = time % 60;
    minutes = (time / 60) % 60;
    if (seconds < 10) {
        _lTotalTime.text = [NSString stringWithFormat:@"%@%d:0%d", minusSignTime, minutes, seconds];
    }else{
        _lTotalTime.text = [NSString stringWithFormat:@"%@%d:%d", minusSignTime, minutes, seconds];
    }
    
    if (triggerNegativeTime == 1) {
        _lTotalTime.text = @"0:00";
    }
    
    
    float mixedCGresult = (([_labelTime2Min.text floatValue] * [_lCG2min.text floatValue]) + (lTimeMCP * [_lCGMCP.text floatValue]))/ lTotalTime;
    
   
    _hinweisMixedCG.hidden = YES;
    
    if (lTimeMCP < 2.0) {
        mixedCGresult = resultCG2minPercent;
        _hinweisMixedCG.hidden = NO;
    }
    //NSLog(@"--------------");
    //NSLog(@"[_labelTime2Min.text floatValue] %f", [_labelTime2Min.text floatValue]);
    //NSLog(@"[_lCG2min.text floatValue] %f", [_lCG2min.text floatValue]);
    //NSLog(@"lTimeMCP %f", lTimeMCP);
    //NSLog(@"[_lCGMCP.text floatValue] %f", [_lCGMCP.text floatValue]);
    //NSLog(@"lTotalTime %f", lTotalTime);    
    //NSLog(@"mixedCGresult %f", mixedCGresult);
  
    
    _lMixedCGPercent.text = [[NSString alloc] initWithFormat:@"%.1f", mixedCGresult ];
    
    
   ViewController *parent = (ViewController *)self.parentViewController;
   dL = [[UILabel alloc] init];  dL = (UILabel *)[ parent.self.viewUniversalButtons viewWithTag:   4 + 200  ];
   dL.text = [[NSString alloc] initWithFormat:@"%.1f %%", mixedCGresult ];
    
    dL = [[UILabel alloc] init];  dL = (UILabel *)[ parent.self.viewUniversalButtons viewWithTag:   4 + 100  ];
    //dL.text = [[NSString alloc] initWithFormat:@"AVG CLB GRAD", _mcgInputAirportElevationMSL.text ];
    dL.text = @"AVG CLB GRAD";
    
    
    /*
    //warning
    if (mixedCGresult < 10.5) {
        _viewColorMixedCG.backgroundColor = [UIColor redColor];            
         ViewController *parent = (ViewController *)self.parentViewController;
        UIImage *buttonRed = [UIImage imageNamed:@"button_red.png"];
        UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: 4 ];
        [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateNormal];
        [buttonToWarn setBackgroundImage:buttonRed forState:UIControlStateSelected];
        
        
    }else{    
        
    _viewColorMixedCG.backgroundColor = [UIColor greenColor]; 
    ViewController *parent = (ViewController *)self.parentViewController;
    UIImage *buttonGrey = [UIImage imageNamed:@"button grey top184x52.png"];
    UIImage *buttonBlue = [UIImage imageNamed:@"button blue top184x52.png"];

        UIButton *buttonToWarn = (UIButton *)[parent.self.viewUniversalButtons viewWithTag: 4 ];
        [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateNormal];
        if ( [buttonToWarn isSelected ]) {
            [buttonToWarn setBackgroundImage:buttonBlue forState:UIControlStateSelected];
        }else{
            [buttonToWarn setBackgroundImage:buttonGrey forState:UIControlStateSelected];
        }
    }
     */
    
   
    
}



- (IBAction)mcgSliderActionAirportElevationSID:(id)sender {
    
    int dummy = _mcgSliderAirportElevationMSL.value/50;
    _mcgSliderAirportElevationMSL.value = dummy * 50;    
    _mcgInputAirportElevationMSL.text = [[NSString alloc] initWithFormat:@"%.0f", _mcgSliderAirportElevationMSL.value ];
    
    [self calcPerformance];
    
}

- (IBAction)closeKeyboardAirportElevation:(id)sender {
    
    _mcgSliderAirportElevationMSL.value = [_mcgInputAirportElevationMSL.text floatValue];
    [self.view endEditing:TRUE];    
    [self calcPerformance];   
    
}

- (IBAction)closeKeyboardDriftDown:(id)sender {
      
    [self.view endEditing:TRUE];    
    [self calcPerformance];  
    [self calcPerformance]; 
    
}



- (IBAction)sliderActionGeschUeber:(id)sender {
    
     int dummy = _sliderGeschUeber.value/1000;
    _sliderGeschUeber.value = dummy * 1000;    
    _lSliderGeschUeberhoehung.text = [[NSString alloc] initWithFormat:@"%.0f ft", _sliderGeschUeber.value ];
    
    [self calcPerformance];
    
}

- (IBAction)sliderActionGeschUeberMEA2:(id)sender {
    
    int dummy = _sliderGeschUeberMEA2.value/1000;
    _sliderGeschUeberMEA2.value = dummy * 1000;    
    _lSliderGeschUeberhoehungMEA2.text = [[NSString alloc] initWithFormat:@"%.0f ft", _sliderGeschUeberMEA2.value ];
    
    [self calcPerformance];
    
}
@end
